/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.executor;

import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Primary
@Component(value="ReferenceClearRunnable")
@Scope(value="prototype")
public class ReferenceClearRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceClearRunnable.class);

    @Override
    public void run() {
        ReferenceQueue<RuleRuntimeContext> referenceQueue = RuleRuntimeContext.referenceQueue;
        int count = 0;
        while (count < Integer.MAX_VALUE) {
            try {
                this.remove(referenceQueue);
            }
            catch (InterruptedException | RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void remove(ReferenceQueue<RuleRuntimeContext> referenceQueue) throws InterruptedException {
        Reference<RuleRuntimeContext> reference = referenceQueue.remove();
        RuleRuntimeContext.clearRuleRuntimeContext(reference);
    }
}

