/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.waiter;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeParallelBranchNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.starter.StarterRuleable;
import com.bizunited.platform.mars.policy.process.rule.waiter.ParallelBranchTask;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="_ParallelBranchRuleable")
public class ParallelBranchRuleable<T extends RuntimeParallelBranchNode>
implements StarterRuleable<RuntimeParallelBranchNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelBranchRuleable.class);
    @Value(value="${mars.branch.judge-size:1000}")
    private Integer judgeSize;
    @Autowired
    private ParallelBranchTask parallelBranchTask;

    @Override
    public int getType() {
        return RuntimeNodeType.MERGE.getValue();
    }

    @Override
    public void doProcess(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
        processChain.doProcessNode(context, runtimeProcessorLinked);
    }

    @Override
    public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context) {
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(nexts), (String)"\u5f53\u524d\u8282\u70b9\u540e\u7eed\u8fd0\u884c\u65f6\u8fde\u7ebf\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        RuntimeNodeType type = currentNode.getType();
        Validate.isTrue((type == RuntimeNodeType.CONCURRENCY ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u4e0d\u662fA/B\u5e76\u53d1\u7c7b\u578b\u7684\u8fd0\u884c\u65f6\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)currentNode.getParamName(), (String)"A/B\u5e76\u884c\u8282\u70b9\u53c2\u6570\u540d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        long noneConditionsSize = nexts.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getConditions())).count();
        Validate.isTrue((noneConditionsSize <= 1L ? 1 : 0) != 0, (String)"A/B\u5e76\u884c\u8282\u70b9\u94fe\u7ebf\u8d85\u8fc71\u6761\u6ca1\u6709\u914d\u7f6e\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String defaultCondition = null;
        if (noneConditionsSize == 1L) {
            StringBuilder condition = new StringBuilder();
            condition.append("!( ");
            condition.append(nexts.stream().filter(item -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getConditions()})).map(next -> StringUtils.appendIfMissing((String)StringUtils.prependIfMissing((String)next.getConditions(), (CharSequence)"(", (CharSequence[])new CharSequence[0]), (CharSequence)")", (CharSequence[])new CharSequence[0])).collect(Collectors.joining(" || ")));
            condition.append(" )");
            defaultCondition = condition.toString();
        }
        Set sortNexts = nexts.stream().filter(item -> item.getLineType() == 1).sorted((source, target) -> source.getSort() - target.getSort()).collect(Collectors.toSet());
        HashSet runtimeProcessorLinkeds = Sets.newHashSet();
        List<?> params = this.getParams(context, currentNode.getParamName());
        Validate.notNull(params, (String)"A/B\u5e76\u884c\u8282\u70b9\u96c6\u5408\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        int size = params.size();
        if (size > this.judgeSize) {
            LOGGER.debug("\u5f02\u6b65\u6267\u884c\u3010{}\u3011,\u6570\u636e\u96c6\u5408\u5927\u5c0f\u3010{}\u3011", (Object)currentNode.getCode(), (Object)size);
            ArrayList futures = Lists.newArrayList();
            for (RuntimeNodeNexts next2 : sortNexts) {
                if (StringUtils.isBlank((CharSequence)next2.getConditions())) {
                    next2.setConditions(defaultCondition);
                }
                Future<RuntimeProcessorLinked> future = this.parallelBranchTask.doAsyncParallelBranchTask(currentNode, context, next2, params);
                futures.add(future);
            }
            try {
                for (Future future : futures) {
                    runtimeProcessorLinkeds.add(future.get());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("A/B\u5e76\u884c\u5206\u652f\u5f02\u6b65\u6267\u884c\u5f02\u5e38,\u8bf7\u68c0\u67e5\uff01");
            }
        } else {
            LOGGER.debug("\u540c\u6b65\u6267\u884c\u3010{}\u3011,\u6570\u636e\u96c6\u5408\u5927\u5c0f\u3010{}\u3011", (Object)currentNode.getCode(), (Object)size);
            for (RuntimeNodeNexts next3 : sortNexts) {
                if (StringUtils.isBlank((CharSequence)next3.getConditions())) {
                    next3.setConditions(defaultCondition);
                }
                runtimeProcessorLinkeds.add(this.parallelBranchTask.doSyncParallelBranchTask(currentNode, context, next3, params));
            }
        }
        return runtimeProcessorLinkeds;
    }

    private List<?> getParams(RuleRuntimeContext context, String paramName) {
        Object params = context.getParams().get(paramName);
        Validate.notNull((Object)params, (String)"A/B\u5e76\u884c\u8282\u70b9\u4e0a\u4e0b\u6587\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((params.getClass().isArray() || Collection.class.isAssignableFrom(params.getClass()) ? 1 : 0) != 0, (String)"\u5236\u5b9a\u53c2\u6570\u4e0d\u662f\u96c6\u5408\u6216\u8005\u6570\u7ec4\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        LinkedList paramList = null;
        if (params.getClass().isArray()) {
            Object[] arr = (Object[])params;
            paramList = Arrays.asList(arr);
        } else if (Collection.class.isAssignableFrom(params.getClass())) {
            Collection collection = (Collection)params;
            paramList = Lists.newLinkedList((Iterable)collection);
        }
        return paramList;
    }

    @Override
    public Class<RuntimeParallelBranchNode> mapping() {
        return RuntimeParallelBranchNode.class;
    }
}

