package com.bizunited.platform.mars.policy.process.cache;

/**
 * 运行节点的类型</p>
 * @author yinwenjie
 */
public enum RuntimeNodeType {
  // 条件判定组件
  CONDITION(1),
  // 逻辑组件
  LOGICAL(2),
  // 锁组件
  LOCK(3),
  // 开始组件
  BEGIN(4),
  // 结束组件
  END(5),
  // A/B并发组件
  CONCURRENCY(6),
  // 并发汇聚组件
  MERGE(7),
  // 时间控制组件
  TIMER(8),
  // 业务自定义组件
  CUSTOM(9);
  
  private int value;
  
  RuntimeNodeType(int value) {
    this.value = value;
  }
  
  public String toString() {
    return Integer.toString(value);
  }
  
  /**
   * 获取为枚举类型设定的整数值
   * @return
   */
  public int getValue() {
    return this.value;
  }
  
  /**
   * 该方法返回和代表值一致的枚举对象 
   * @param code 
   * @return 
   */ 
  public static RuntimeNodeType findByValue(int code) {
    RuntimeNodeType[] items = RuntimeNodeType.values();
    for(RuntimeNodeType item : items) {
      if(item.getValue() == code) {
        return item;
      } 
    } 
    return null;
  } 
}