package com.bizunited.platform.mars.policy.process.cache.ext;

import org.apache.commons.lang3.Validate;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;

/**
 * 业务扩展节点：</p>
 * 为了满足不同业务系统在节点模板管理和规则定义阶段，能够加入由复杂页面进行人机交互的，带有较强业务意义的节点。</br>
 * 规则引擎提供了这样的运行时节点扩展描述，在这里用户可以对这些自己开发的具有较强业务意义的节点进行运行时描述，并用于支持特定处理器的执行</p>
 * 请注意这类业务扩展节点和逻辑节点的区别：</br>
 * 1、逻辑节点也支持业务性质的页面，但是前者支持的页面主要有（动态）表单引擎和列表引擎提供；</br>
 * 业务扩展节点的页面则更为宽泛，业务扩展节点支持第三方页面和（动态）表单引擎页面</p>
 * 
 * 2、逻辑节点的处理器相对固定，这是由于逻辑节点有入参、出参和处理模式的约束，所以可以使用相对固定的处理器</br>
 * 但是业务扩展节点，则需要业务（开发/交付）团队，根据业务需求，自行进行页面和处理器的开发。</p>
 * 
 * 3、由于逻辑节点的处理器支持出参和入参设定，这种设定可以简化处理器中的编码方式；</br>
 * 但是业务扩展节点，由于业务（开发/交付）团队理解出参和入参的成本较高，也不应该花成本理解规则引擎中的具体运行逻辑</br>
 * 所以业务扩展节点无需设定出参和入参。</p>
 * 
 * 4、逻辑节点是否使用（动态）表单引擎或者是否使用列表引擎页面，是一种可选配置。甚至可以不用任何配置页面；</br>
 * 但是逻辑节点
 * @author yinwenjie
 *
 */
public class RuntimeExtNode extends RuntimeNode implements Mappable<RuleNodeEntity, RuntimeNode> {
  /**
   * 业务扩展节点的类型，可由技术团队自行设定
   */
  private Integer extType;
  /**
   * 弹窗的高度，可以是像素或者百分比
   */
  private Integer showHight;
  /**
   * 弹窗的宽度，可以是像素或者百分比
   */
  private Integer showWidth;
  /**
   * 如果需要进行页面引擎弹窗，则这里可填写弹窗的标题信息
   */
  private String showTitle;
  /**
   * 这个业务扩展组件是否使用（动态）表单引擎作为操作界面
   */
  private Boolean formEngine;
  /**
   * 当前表单引擎使用的表单实例号
   */
  private String formInstanceId;
  /**
   * 这个业务扩展组件是否使用用户自定义的业务扩展页面
   */
  private Boolean userPage;
  /**
   * 当业务扩展组件在规则定义页面进行设定数据保存时，向表单页面提供的业务数据唯一标识信息</br>
   * 例如，如果是订单页面，则可能返回订单数据的id
   */
  private String taskCode;
  /**
   * 当业务扩展组件需要在规则定义页面需要展开并回显数据时</br>
   * 就会使用该参数名进行url请求，例如:/xxxx/show?taskName=taskCode;
   */
  private String taskName;
  public Integer getExtType() {
    return extType;
  }
  public void setExtType(Integer extType) {
    this.extType = extType;
  }
  public Integer getShowHight() {
    return showHight;
  }
  public void setShowHight(Integer showHight) {
    this.showHight = showHight;
  }
  public Integer getShowWidth() {
    return showWidth;
  }
  public void setShowWidth(Integer showWidth) {
    this.showWidth = showWidth;
  }
  public String getShowTitle() {
    return showTitle;
  }
  public void setShowTitle(String showTitle) {
    this.showTitle = showTitle;
  }
  public Boolean getFormEngine() {
    return formEngine;
  }
  public void setFormEngine(Boolean formEngine) {
    this.formEngine = formEngine;
  }
  public String getFormInstanceId() {
    return formInstanceId;
  }
  public void setFormInstanceId(String formInstanceId) {
    this.formInstanceId = formInstanceId;
  }
  public Boolean getUserPage() {
    return userPage;
  }
  public void setUserPage(Boolean userPage) {
    this.userPage = userPage;
  }
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getTaskName() {
    return taskName;
  }
  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }
  @Override
  public RuntimeNode mappingTransform(RuleNodeEntity ruleNode) {
    RuntimeExtNode currentNode = super.doMappingTransform(RuntimeExtNode.class, ruleNode);
    Integer extType = currentNode.getExtType();
    Validate.notNull(extType , "错误的业务扩展节点类型[extType]，请检查!!");
    return null;
  }
}

