package com.bizunited.platform.mars.policy.process.cache.waiter;

import com.bizunited.platform.mars.entity.RuleConcurrentAggregationEntity;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;
import org.apache.commons.lang3.Validate;

/**
 * A/B并发分支节点运行时信息
 *
 * @author yinwenjie
 */
public class RuntimeParallelBranchNode extends RuntimeDelayNode implements Mappable<RuleNodeEntity, RuntimeParallelBranchNode> {

  /**
   * 扩展参数名
   */
  private String paramName;

  @Override
  public RuntimeParallelBranchNode mappingTransform(RuleNodeEntity ruleNode) {
    RuntimeParallelBranchNode runtimeParallelBranchNode = super.doMappingTransform(RuntimeParallelBranchNode.class, ruleNode);
    RuleConcurrentAggregationEntity ruleAggregationExt = ruleNode.getRuleAggregationExt();
    Validate.notNull(ruleAggregationExt, "A/B并行节点扩展信息为空，请检查！");
    runtimeParallelBranchNode.setParamName(ruleAggregationExt.getParamName());
    return runtimeParallelBranchNode;
  }

  public String getParamName() {
    return this.paramName;
  }

  public void setParamName(String paramName) {
    this.paramName = paramName;
  }
}