/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.configuration;

import com.bizunited.platform.mars.policy.process.configuration.MarsExecutorProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
public class MarsTaskConfiguration {
    @Bean(value={"marsTaskExecutor"})
    public ThreadPoolTaskExecutor taskExecutor(MarsExecutorProperties properties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(properties.getTaskInitSize());
        executor.setMaxPoolSize(properties.getTaskMaxSize());
        executor.setQueueCapacity(10);
        executor.setThreadNamePrefix("mars-task-executor-");
        executor.setAwaitTerminationSeconds(0);
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.initialize();
        return executor;
    }
}

