/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.waiter;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeParallelBranchNode;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeDefinitionService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component(value="parallelBranchTask")
public class ParallelBranchTask {
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeDefinitionService runtimeDefinitionService;
    @Autowired
    private ScriptService scriptService;

    public RuntimeProcessorLinked doSyncParallelBranchTask(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context, RuntimeNodeNexts next, List<?> params) {
        String conditions = next.getConditions();
        HashSet branchParams = Sets.newHashSet();
        for (Object param : params) {
            Object evalResult = this.executeGroovyScript(conditions, context.getParams(), param);
            if (evalResult == null || Boolean.class != evalResult.getClass()) {
                throw new IllegalArgumentException("\u6761\u4ef6\u5224\u5b9a\u5206\u652f\u7684\u8fd4\u56de\u503c\uff0c\u53ea\u80fd\u662fboolean\u578b\uff0c\u8bf7\u68c0\u67e5!!");
            }
            if (!Boolean.TRUE.equals(evalResult)) continue;
            branchParams.add(param);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{next.getBindParam()})) {
            context.getParams().put(next.getBindParam(), branchParams);
        }
        RuntimeProcessorLinked runtimeProcessorLinked = new RuntimeProcessorLinked(currentNode, next);
        return runtimeProcessorLinked;
    }

    @Async(value="marsTaskExecutor")
    public Future<RuntimeProcessorLinked> doAsyncParallelBranchTask(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context, RuntimeNodeNexts next, List<?> params) {
        String conditions = next.getConditions();
        HashSet branchParams = Sets.newHashSet();
        for (Object param : params) {
            Object evalResult = this.executeGroovyScript(conditions, context.getParams(), param);
            if (evalResult == null || Boolean.class != evalResult.getClass()) {
                throw new IllegalArgumentException("\u6761\u4ef6\u5224\u5b9a\u5206\u652f\u7684\u8fd4\u56de\u503c\uff0c\u53ea\u80fd\u662fboolean\u578b\uff0c\u8bf7\u68c0\u67e5!!");
            }
            if (!Boolean.TRUE.equals(evalResult)) continue;
            branchParams.add(param);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{next.getBindParam()})) {
            context.getParams().put(next.getBindParam(), branchParams);
        }
        RuntimeProcessorLinked runtimeProcessorLinked = new RuntimeProcessorLinked(currentNode, next);
        return new AsyncResult((Object)runtimeProcessorLinked);
    }

    private Object executeGroovyScript(String scriptContxt, Map<String, Object> contentMap, Object content) {
        HashMap scriptInputsMap = Maps.newHashMap(contentMap);
        scriptInputsMap.put("data", content);
        scriptInputsMap.put("runtimeNodeService", this.runtimeNodeService);
        scriptInputsMap.put("runtimeDefinitionService", this.runtimeDefinitionService);
        return this.scriptService.invoke(scriptContxt, (Map)scriptInputsMap);
    }
}

