package com.bizunited.platform.mars.policy.process.rule.waiter;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeParallelBranchNode;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeDefinitionService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

/**
 * A/B并行分支，分支条件执行与参数任务执行器
 *
 * @author Keller
 */
@Component("parallelBranchTask")
public class ParallelBranchTask {

  @Autowired
  private RuntimeNodeService runtimeNodeService;
  @Autowired
  private RuntimeDefinitionService runtimeDefinitionService;
  @Autowired
  private ScriptService scriptService;

  public RuntimeProcessorLinked doSyncParallelBranchTask(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context, RuntimeNodeNexts next, List<?> params) {
    /*
     * 同步执行A/B分支的参数拆分
     *
     * 1、准备数据
     * 2、执行判断
     * 3、根据线路参数设置上下参数
     * 4、创建链路RuntimeProcessorLinked
     */
    // 1、准备数据
    String conditions = next.getConditions();
    Set<Object> branchParams = Sets.newHashSet();
    // 2、执行判断
    for (Object param : params) {
      // 执行
      Object evalResult = this.executeGroovyScript(conditions, context.getParams(), param);
      if (evalResult == null || Boolean.class != evalResult.getClass()) {
        throw new IllegalArgumentException("条件判定分支的返回值，只能是boolean型，请检查!!");
      }
      // 如果条件成立，说明参数符合该分支，参数写入该分支
      if (Boolean.TRUE.equals(evalResult)) {
        branchParams.add(param);
      }
    }
    // 3、根据线路参数设置上下参数 运行为空不设置
    if (StringUtils.isNoneBlank(next.getBindParam())) {
      context.getParams().put(next.getBindParam(), branchParams);
    }
    // 4、创建链路RuntimeProcessorLinked
    RuntimeProcessorLinked runtimeProcessorLinked = new RuntimeProcessorLinked(currentNode, next);
    return runtimeProcessorLinked;
  }

  @Async("marsTaskExecutor")
  public Future<RuntimeProcessorLinked> doAsyncParallelBranchTask(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context, RuntimeNodeNexts next, List<?> params) {
    /*
     * 异步执行A/B分支的参数拆分
     * 等到所有分支拆分好以后在放入RuntimeProcessorLinked中
     *
     * 1、准备数据
     * 2、执行判断
     * 3、根据线路参数设置上下参数
     * 4、创建链路RuntimeProcessorLinked
     */
    // 1、准备数据
    String conditions = next.getConditions();
    Set<Object> branchParams = Sets.newHashSet();
    // 2、执行判断
    for (Object param : params) {
      // 执行
      Object evalResult = this.executeGroovyScript(conditions, context.getParams(), param);
      if (evalResult == null || Boolean.class != evalResult.getClass()) {
        throw new IllegalArgumentException("条件判定分支的返回值，只能是boolean型，请检查!!");
      }
      // 如果条件成立，说明参数符合该分支，参数写入该分支
      if (Boolean.TRUE.equals(evalResult)) {
        branchParams.add(param);
      }
    }
    // 3、根据线路参数设置上下参数 运行为空不设置
    if (StringUtils.isNoneBlank(next.getBindParam())) {
      context.getParams().put(next.getBindParam(), branchParams);
    }
    // 4、创建链路RuntimeProcessorLinked
    RuntimeProcessorLinked runtimeProcessorLinked = new RuntimeProcessorLinked(currentNode, next);
    return new AsyncResult<>(runtimeProcessorLinked);
  }

  /**
   * 在全动态后端groovy脚本的场景下，运行实际的动态脚本代码
   *
   * @param scriptContxt 条件脚本
   * @param content      上下文参数
   * @return 返回执行条件下的数组或者集合
   */
  private Object executeGroovyScript(String scriptContxt, Map<String, Object> contentMap, Object content) {
    // 进行上下文已有参数绑定后执行
    Map<String, Object> scriptInputsMap = Maps.newHashMap(contentMap);
    scriptInputsMap.put("data", content);
    scriptInputsMap.put("runtimeNodeService", runtimeNodeService);
    scriptInputsMap.put("runtimeDefinitionService", runtimeDefinitionService);
    return this.scriptService.invoke(scriptContxt, scriptInputsMap);
  }
}
