package com.bizunited.platform.mars.policy.process.runtime.service;

import java.util.Map;

/**
 * 规则实例运行所需要的完整规则信息，在这里被进行查询、操作和缓存
 * @author yinwenjie
 */
public interface RuntimeDefinitionService {
  /**
   * 对一个指定的规则定义发起请求调用（同步调用），只有当规则执行正常完成返回了结果或者异常执行抛出了运行时异常，调用者才能向后执行：</br>
   * 能够执行同步调用的规则定义有以下特点：</br>
   * 1、只有一个开始节点且只有一个唯一的结束节点</br>
   * 2、整个规则定义中没有时间等待节点，即使存在这样的节点，其节点也不能存在真实延时效果；</br>
   * 只有满足这两个要求的规则定义，才能进行同步调用，这主要是保证处理线程不被当前业务请求长期占据，导致系统响应度严重降低
   * @param code 指定的规则定义的业务编号
   * @param version 指定的规则定义的版本信息
   * @param params 如果有外部的参数，则从这里进行传入
   * @return 如果当前规则定义指定了存在调用结果，在调用成功的前提下，调用结果将被返回
   */
  Object process(String code , String version , Map<String , Object> params) throws RuntimeException;
  
  /**
   * 对一个指定的规则定义发起请求调用（异步调用），调用后调用者可以继续向后执行，不用等待规则引擎执行完毕
   * @param code 指定的规则定义的业务编号
   * @param version 指定的规则定义的版本信息
   * @param params 如果有外部的参数，则从这里进行传入
   */
  Object processAsync(String code , String version , Map<String , Object> params);
}