/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.executor;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeExtNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorLinkedChainRunnable;
import com.bizunited.platform.mars.policy.process.rule.Ruleable;
import com.bizunited.platform.mars.policy.process.rule.ext.AbstractExtRuleable;
import com.bizunited.platform.mars.policy.process.rule.starter.StarterRuleable;
import com.bizunited.platform.mars.policy.process.runtime.RuleRunTimeStatus;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeProcessorLinkedService;
import java.util.List;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Primary
@Component(value="TimerNotifyRunnable")
@Scope(value="prototype")
public class TimerNotifyRunnable
implements Runnable {
    @Autowired
    @Qualifier(value="_delayTimerQueue")
    private DelayQueue<RuntimeDelayNode> delayQueue;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RuntimeProcessorLinkedService runtimeProcessorLinkedService;
    @Autowired
    private List<Ruleable<RuntimeNode>> ruleables;
    private static final Logger LOGGER = LoggerFactory.getLogger(TimerNotifyRunnable.class);

    @Override
    public void run() {
        Long count = 0L;
        while (true) {
            Thread currentThread;
            Long l = count;
            Long l2 = count = Long.valueOf(count + 1L);
            if (l >= Long.MAX_VALUE || (currentThread = Thread.currentThread()).isInterrupted()) break;
            RuntimeDelayNode currentNode = null;
            try {
                currentNode = (RuntimeDelayNode)this.delayQueue.take();
            }
            catch (InterruptedException e) {
                LOGGER.error("\u53d1\u73b0\u7ec8\u6b62\u4fe1\u53f7\uff0c\u8bf7\u907f\u514d\u4f7f\u7528kill -9\u7684\u65b9\u5f0f\u5f3a\u5236\u7ec8\u7ed3\u8fdb\u7a0b\uff0c\u5728\u540e\u7eed\u7248\u672c\u4e2d\uff0cmars\u6a21\u5757\u5c06\u518d\u9000\u51fa\u524d\u5b8c\u6210\u672a\u5904\u7406\u4efb\u52a1\u7684\u843d\u76d8\u5907\u4efd\u5904\u7406!!");
                Thread.currentThread().interrupt();
                break;
            }
            String instanceId = currentNode.getInstanceId();
            RuleRuntimeContext ruleRuntimeContext = RuleRuntimeContext.getRuleRuntimeContext(instanceId);
            try {
                this.doChain(currentNode, ruleRuntimeContext);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                ruleRuntimeContext.setCurrentThrowable(e);
                ruleRuntimeContext.setExceptionLevel(0);
                ruleRuntimeContext.setStatus(RuleRunTimeStatus.EXCEPTION);
                Thread requestThread = ruleRuntimeContext.getRequestThread();
                if (requestThread == null) continue;
                LockSupport.unpark(requestThread);
            }
        }
    }

    public void doChain(RuntimeDelayNode currentNode, RuleRuntimeContext ruleRuntimeContext) {
        Ruleable<RuntimeNode> currentRuleable = this.findRuleable(currentNode);
        Validate.notNull(currentRuleable, (String)"\u6ca1\u53d1\u73b0\u6307\u5b9a\u8fd0\u884c\u65f6\u8282\u70b9[%s]\uff0c\u5bf9\u5e94\u7684\u6267\u884c\u5668Runable\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentNode.getClass().getName()});
        Validate.isTrue((boolean)(currentRuleable instanceof StarterRuleable), (String)"\u5f53\u524d\u8282\u70b9\u5e76\u4e0d\u662f\u4e00\u79cd\u94fe\u8def\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5b9a!!", (Object[])new Object[0]);
        StarterRuleable starterRuleable = (StarterRuleable)currentRuleable;
        Set<RuntimeProcessorLinked> runtimeProcessorLinkeds = starterRuleable.createProcessorLinkeds(currentNode, ruleRuntimeContext);
        if (CollectionUtils.isEmpty(runtimeProcessorLinkeds)) {
            LOGGER.debug("\u57fa\u4e8e\u8282\u70b9\u8fd0\u884c\u65f6[%]\u4e3a\u5f00\u59cb\u8282\u70b9\u7684\u94fe\u8def\uff0c\u672a\u88ab\u5efa\u7acb\uff1b\u53ef\u80fd\u662f\u56e0\u4e3a\u672a\u8fbe\u5230\u7ee7\u7eed\u8fd0\u884c\u7684\u89e6\u53d1\u6761\u4ef6");
            return;
        }
        ThreadPoolExecutor marsExtcutorExecutor = (ThreadPoolExecutor)this.applicationContext.getBean("mars_extcutor_thread_pool", ThreadPoolExecutor.class);
        for (RuntimeProcessorLinked runtimeProcessorLinked : runtimeProcessorLinkeds) {
            this.runtimeProcessorLinkedService.start(ruleRuntimeContext, runtimeProcessorLinked);
            ProcessorLinkedChainRunnable processorLinkedChain = (ProcessorLinkedChainRunnable)this.applicationContext.getBean("ProcessorLinkedChainRunnable", new Object[]{ruleRuntimeContext, runtimeProcessorLinked});
            marsExtcutorExecutor.submit(processorLinkedChain);
        }
    }

    private Ruleable<RuntimeNode> findRuleable(RuntimeNode currentNode) {
        RuntimeNodeType runtimeNodeType = currentNode.getType();
        if (runtimeNodeType == RuntimeNodeType.CUSTOM && currentNode instanceof RuntimeExtNode) {
            RuntimeExtNode runtimeExtNode = (RuntimeExtNode)currentNode;
            for (Ruleable<RuntimeNode> item : this.ruleables) {
                AbstractExtRuleable extRuleable;
                int mappingExtType;
                if (!AbstractExtRuleable.class.isAssignableFrom(item.getClass()) || (mappingExtType = (extRuleable = (AbstractExtRuleable)item).mappingExtType()) != runtimeExtNode.getExtType()) continue;
                return item;
            }
        } else {
            for (Ruleable<RuntimeNode> item : this.ruleables) {
                if (item.mapping() != currentNode.getClass()) continue;
                return item;
            }
        }
        return null;
    }
}

