/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.logic;

import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeServicableNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.logic.AbstractLogicRuleable;
import com.bizunited.platform.mars.policy.process.rule.logic.LogicRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="servicableProcessRuleable")
public class ServicableProcessRuleable<T extends RuntimeServicableNode>
extends AbstractLogicRuleable<RuntimeServicableNode>
implements LogicRuleable<RuntimeServicableNode> {
    @Autowired
    private ServicableMethodService servicableMethodService;

    @Override
    public void doProcess(RuntimeServicableNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
        super.process(currentNode, runtimeProcessorLinked);
        processChain.doProcessNode(context, runtimeProcessorLinked);
    }

    @Override
    protected void execute(RuntimeServicableNode currentNode, Map<String, Object> inputParamValues, RuleRuntimeContext context) {
        String code = currentNode.getCode();
        String servicableMethod = currentNode.getServicableMethod();
        Validate.notBlank((CharSequence)servicableMethod, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u670d\u52a1\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        InvokeParams invokeParams = new InvokeParams(inputParamValues);
        Object result = null;
        try {
            result = this.servicableMethodService.invoke(servicableMethod, invokeParams);
        }
        catch (InvokeProxyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        Map<String, Object> contentMap = context.getParams();
        Set<RuntimeNodeParams> outputParams = currentNode.getOutputs();
        Validate.isTrue((outputParams == null || outputParams.size() == 0 || outputParams != null && outputParams.size() == 1 ? 1 : 0) != 0, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u53d1\u73b0\u5176\u8bbe\u5b9a\u7684\u51fa\u53c2\u4e0d\u7b26\u5408\u8981\u6c42(\u8981\u4e48\u4e0d\u8bbe\u5b9a\u8fd4\u56de\u503c\uff0c\u8981\u4e48\u53ea\u8bbe\u7f6e\u4e00\u4e2a\u8fd4\u56de\u503c\u53c2\u6570)!!", (Object[])new Object[]{code});
        if (outputParams != null) {
            RuntimeNodeParams outputParam = outputParams.iterator().next();
            String contextParamName = outputParam.getContextParamName();
            contentMap.put(contextParamName, result);
        }
    }

    @Override
    public Class<RuntimeServicableNode> mapping() {
        return RuntimeServicableNode.class;
    }
}

