package com.bizunited.platform.mars.service.process;

import java.util.Map;

import com.bizunited.platform.mars.service.cache.RuntimeDefinition;

/**
 * 规则实例运行所需要的完整规则信息，在这里被进行查询、操作和缓存
 * @author yinwenjie
 */
public interface RuntimeDefinitionService {
  /**
   * 通过给定的规则定义编号和版本信息，查询完整的规则描述。
   * 规则描述信息将基于持久层存储的规则定义信息生成，并被缓存到内存中
   * @param code 指定的规则定义编号
   * @param version 指定的规则定义版本
   * @return
   */
  RuntimeDefinition findDetailsByCodeAndVersion(String code , String version);
  /**
   * 针对一个新的规则定义，进行创建操作。注意：</br>
   * 创建操作时，规则定义的基本信息和附属信息，都不能包含ID信息，具体的信息结构可参见文档示例
   * @param definition 新的规则定义结构
   * @param fileContent 前端布局文件内容信息
   * @return 如果该规则定义创建成功，则信息结构本身将被返回，并且这个信息的基本信息、附属信息中都将包括id属性
   */
  RuntimeDefinition create(RuntimeDefinition definition, byte[] fileContent);
  /**
   * 针对一个已有的规则定义，进行该规则定义的全量修改。所谓全量修改，就是之前的规则定义信息会全部作废
   * @param definition 指定的规则定义，其中id信息必须有值
   * @param fileContent 前端布局文件内容信息
   * @return
   */
  RuntimeDefinition update(RuntimeDefinition definition, byte[] fileContent);
  
  /**
   * 对一个指定规则定义发起请求调用，一次调用将使用一个独立的ProcessChain对象进行调用过程管理
   * @param code 指定的规则定义的业务编号
   * @param version 指定的规则定义的版本信息
   * @param params 如果有外部的参数，则从这里进行传入
   * @return 如果当前规则定义指定了存在调用结果，在调用成功的前提下，调用结果将被返回
   */
  Object process(String code , String version , Map<String , Object> params);
}