package com.bizunited.platform.mars.service.process.executor;

import java.util.Map;

import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;

/**
 * 执行器，用于根据节点定义，执行具体的处理过程。</p>
 * 目前一共有四种执行器的实现：ServicableProcessExecutor、DynamicGroovyScriptProcessExecutor、GroovyScriptProcessExecutor、AggregateDataViewProcessExecutor</p>
 * 执行器设定的sourceType的值，和节点定义中的sourceType值一致时，这个执行器将工作
 * @author yinwenjie
 */
public interface ProcessExecutor {
  /**
   * 1、服务源；2、数据视图（聚集）、3、后台脚本；5、全动态脚本
   * 设定该执行器兼容的sourceType值
   * @return
   */
  public int getSourceType();
  /**
   * 该方法被具体的执行器实现，用来完成不同设定场景下具体的业务逻辑处理过程
   * @param currentNode
   * @param inputParamValues
   * @param runtimeContext
   */
  public void execute(RuntimeNode currentNode , Map<String , Object> inputParamValues , RuleRuntimeContext context);
}
