package com.bizunited.platform.mars.service.rule.start;

import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.service.process.ProcessChain;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;

/**
 * 开始规则的简单实现，里面实际上什么都没有
 * @author yinwenjie
 */
@Component("simpleStarterRuleable")
public class SimpleStarterRuleable implements StarterRuleable {

  @Override
  public void doProcessNode(RuntimeNode currentNode ,RuleRuntimeContext context, ProcessChain processChain) {
    // TODO 这里要进行执行日志的写入
    /*
     * 开始位置，会按照当前开始节点的定义，检查入参情况是否满足
     * */
    Set<RuntimeNodeParams> runtimeNodeParams = currentNode.getInputs();
    Map<String, Object> contextParamMapping = context.getParams();
    
    if(runtimeNodeParams != null) {
      for (RuntimeNodeParams nodeParam : runtimeNodeParams) {
        boolean nullable = nodeParam.getNullable();
        String contextParamName = nodeParam.getContextParamName();
        if(nullable && contextParamMapping.get(contextParamName) == null) {
          throw new IllegalArgumentException(String.format("本规则实例要求[%s]作为入参，但是在运行开始时的检测中，并为发现该参数传入，请检查调用时的传参!!", contextParamName));
        }
      }
    }
    processChain.doProcessNode(null);
  }
}