/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.process;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.entity.RuleTemplateParamsEntity;
import com.bizunited.platform.mars.service.RuleTemplateNodeEntityService;
import com.bizunited.platform.mars.service.cache.RuntimeDefinition;
import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.service.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.service.process.AbstractRuntimeService;
import com.bizunited.platform.mars.service.process.ApplicationProcessChain;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;
import com.bizunited.platform.mars.service.process.RuntimeDefinitionService;
import com.bizunited.platform.mars.service.process.RuntimeNodeService;
import com.bizunited.platform.mars.service.process.executor.ProcessExecutor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="SimpleRuntimeNodeService")
public class SimpleRuntimeNodeService
extends AbstractRuntimeService
implements RuntimeNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRuntimeNodeService.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeDefinitionService runtimeDefinitionService;
    @Autowired
    private RuleTemplateNodeEntityService ruleTemplateNodeService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private List<ProcessExecutor> processExecutors;

    @Override
    public RuntimeNode findStartByCodeAndVersion(RuntimeDefinition currentDefinition) {
        if (currentDefinition == null) {
            return null;
        }
        Set<RuntimeNode> nodes = currentDefinition.getNodes();
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        return nodes.stream().filter(item -> item.getType() == 4).findFirst().orElse(null);
    }

    @Override
    public RuntimeNode findNextByDefinition(RuntimeNode currentNode, RuleRuntimeContext context) {
        if (!this.validate(currentNode, context)) {
            return null;
        }
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        Set<RuntimeNode> nodes = context.getCurrentDefinition().getNodes();
        Integer type = currentNode.getType();
        if (type != 1) {
            Validate.isTrue((nexts.stream().filter(item -> item.getLineType() == 1).count() == 1L ? 1 : 0) != 0, (String)"\u5f53\u524d\u8fd0\u884c\u7684\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\uff0c\u4e0d\u662f\u6761\u4ef6\u7c7b\u578b\u7684\u8282\u70b9\uff0c\u4e0d\u80fd\u6709\u591a\u4e2a\u5e38\u89c4\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            RuntimeNodeNexts next = nexts.stream().filter(item -> item.getLineType() == 1).findFirst().orElse(null);
            String nodeCode = next.getToNodeCode();
            RuntimeNode targetNode = nodes.stream().filter(item -> StringUtils.equals((CharSequence)item.getCode(), (CharSequence)nodeCode)).findFirst().orElse(null);
            Validate.notNull((Object)targetNode, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u8282\u70b9\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
            return targetNode;
        }
        Set sortNexts = nexts.stream().filter(item -> item.getLineType() == 1).sorted((source, target) -> source.getSort() - target.getSort()).collect(Collectors.toSet());
        RuntimeNodeNexts currentNext = null;
        for (RuntimeNodeNexts next : sortNexts) {
            String conditions = next.getConditions();
            if (StringUtils.isBlank((CharSequence)conditions)) continue;
            Object evalResult = this.executeGroovyScript(conditions, context.getParams());
            if (evalResult == null || Boolean.class != evalResult.getClass()) {
                throw new IllegalArgumentException("\u6761\u4ef6\u5224\u5b9a\u5206\u652f\u7684\u8fd4\u56de\u503c\uff0c\u53ea\u80fd\u662fboolean\u578b\uff0c\u8bf7\u68c0\u67e5!!");
            }
            if (!((Boolean)evalResult).booleanValue()) continue;
            currentNext = next;
            break;
        }
        if (currentNext == null) {
            currentNext = sortNexts.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getConditions())).findFirst().orElse(null);
        }
        Validate.notNull(currentNext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7b26\u5408\u6761\u4ef6\u7684\u8fd0\u884c\u5206\u652f\uff0c\u4e5f\u6ca1\u6709\u53d1\u73b0\u672a\u8bbe\u7f6e\u8fd0\u884c\u6761\u4ef6\u7684\u9ed8\u8ba4\u5206\u652f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String toNodeCode = currentNext.getToNodeCode();
        RuntimeNode targetNode = nodes.stream().filter(item -> item.getCode() == toNodeCode).findFirst().orElse(null);
        Validate.notNull((Object)targetNode, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u8282\u70b9\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{toNodeCode});
        return targetNode;
    }

    private Object executeGroovyScript(String scriptContxt, Map<String, Object> contentMap) {
        HashMap<String, Object> scriptInputsMap = new HashMap<String, Object>(contentMap);
        scriptInputsMap.put("runtimeNodeService", this.runtimeNodeService);
        scriptInputsMap.put("runtimeDefinitionService", this.runtimeDefinitionService);
        return this.scriptService.invoke(scriptContxt, scriptInputsMap);
    }

    private boolean validate(RuntimeNode currentNode, RuleRuntimeContext context) {
        if (currentNode == null || context == null) {
            return false;
        }
        String fromId = currentNode.getId();
        Integer type = currentNode.getType();
        if (StringUtils.isBlank((CharSequence)fromId)) {
            return false;
        }
        if (type == 5) {
            return false;
        }
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        if (CollectionUtils.isEmpty(nexts)) {
            throw new IllegalArgumentException("\u672a\u53d1\u73b0\u6307\u5b9a\u8282\u70b9\u7684\u540e\u7eed\u8282\u70b9\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u6a21\u677f\u8bbe\u5b9a!!");
        }
        return true;
    }

    @Override
    public RuntimeNode findExceptionNextByDefinition(RuntimeNode currentNode, RuleRuntimeContext context) {
        Set sortNexts;
        if (!this.validate(currentNode, context)) {
            return null;
        }
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        Set<RuntimeNode> nodes = context.getCurrentDefinition().getNodes();
        Throwable currentThrowable = context.getCurrentThrowable();
        if (currentThrowable == null) {
            return null;
        }
        if (currentThrowable instanceof InvocationTargetException) {
            currentThrowable = ((InvocationTargetException)currentThrowable).getTargetException();
        }
        if (CollectionUtils.isEmpty(sortNexts = nexts.stream().filter(item -> item.getLineType() == 2).sorted((source, target) -> source.getSort() - target.getSort()).collect(Collectors.toSet()))) {
            return null;
        }
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        RuntimeNodeNexts currentNext = null;
        for (RuntimeNodeNexts next : sortNexts) {
            String[] exceptionValues;
            String exceptions = next.getExceptions();
            if (StringUtils.isBlank((CharSequence)exceptions)) continue;
            for (String exceptionValue : exceptionValues = StringUtils.split((String)exceptions, (String)",")) {
                Class<?> exceptionClass = null;
                try {
                    exceptionClass = classLoader.loadClass(exceptionValue);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException(String.format("\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u5f02\u5e38\u5b9a\u4e49\u7c7b[%s]\uff0c\u8bf7\u68c0\u67e5!!", exceptionValue), e);
                }
                if (!exceptionClass.isAssignableFrom(currentThrowable.getClass())) continue;
                currentNext = next;
            }
        }
        if (currentNext == null) {
            currentNext = sortNexts.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getConditions())).findFirst().orElse(null);
        }
        if (currentNext == null) {
            return null;
        }
        String toNodeCode = currentNext.getToNodeCode();
        RuntimeNode targetNode = nodes.stream().filter(item -> item.getCode() == toNodeCode).findFirst().orElse(null);
        Validate.notNull((Object)targetNode, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u8282\u70b9[%s]\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{toNodeCode});
        return targetNode;
    }

    @Override
    public Object process(String templateNodeCode, String returnParamName) {
        return this.process(templateNodeCode, null, returnParamName);
    }

    @Override
    public Object process(String templateNodeCode, Map<String, Object> params, String returnParamName) {
        Validate.notBlank((CharSequence)templateNodeCode, (String)"\u9519\u8bef\u7684\u6a21\u677f\u8282\u70b9\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleTemplateNodeEntity ruleTemplateNode = this.ruleTemplateNodeService.findDetailsByCode(templateNodeCode);
        Validate.notNull((Object)ruleTemplateNode, (String)"\u672a\u53d1\u73b0\u6307\u5b9acode[%s]\u7684\u8282\u70b9\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateNodeCode});
        RuntimeNode currentNode = new RuntimeNode();
        int sourceType = ruleTemplateNode.getSourceType();
        int type = ruleTemplateNode.getType();
        Validate.isTrue((type == 2 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u57fa\u4e8e\u8282\u70b9\u6a21\u677f\u7684\u8282\u70b9\u52a8\u6001\u6267\u884c\u65f6\uff0c\u53ea\u652f\u6301\u903b\u8f91\u7ec4\u4ef6\u7684\u4f7f\u7528\u3002\u5426\u5219\u8bf7\u76f4\u63a5\u4f7f\u7528ApplicationProcessChain\u8fdb\u884c\u89c4\u5219\u5b9a\u4e49\u7684\u8c03\u7528!!", (Object[])new Object[0]);
        currentNode.setSourceType(sourceType);
        currentNode.setTemplateNodeId(ruleTemplateNode.getId());
        currentNode.setType(ruleTemplateNode.getType());
        currentNode.setCode(UUID.randomUUID().toString());
        Set templateInputsParams = ruleTemplateNode.getInputs();
        HashSet<RuntimeNodeParams> inputs = new HashSet<RuntimeNodeParams>();
        if (!CollectionUtils.isEmpty((Collection)templateInputsParams)) {
            for (RuleTemplateParamsEntity templateInputsParam : templateInputsParams) {
                inputs.add(this.bindingRuntimeNodeParams(templateInputsParam));
            }
        }
        currentNode.setInputs(inputs);
        Set templateOutputsParams = ruleTemplateNode.getOutputs();
        HashSet<RuntimeNodeParams> outputs = new HashSet<RuntimeNodeParams>();
        if (!CollectionUtils.isEmpty((Collection)templateOutputsParams)) {
            for (RuleTemplateParamsEntity templateOutputsParam : templateOutputsParams) {
                outputs.add(this.bindingRuntimeNodeParams(templateOutputsParam));
            }
        }
        currentNode.setOutputs(outputs);
        switch (sourceType) {
            case 1: {
                currentNode.setSourceServicable(super.parseByRuntimeSourceServicable(ruleTemplateNode, templateNodeCode));
                break;
            }
            case 2: {
                currentNode.setSourceAggregateDataView(super.parseByRuntimeSourceAggregateDataView(ruleTemplateNode, templateNodeCode));
                break;
            }
            case 3: {
                currentNode.setSourceScript(super.parseByRuntimeSourceScript(ruleTemplateNode, templateNodeCode));
                break;
            }
        }
        this.process(currentNode, params);
        if (StringUtils.isBlank((CharSequence)returnParamName)) {
            return null;
        }
        RuleRuntimeContext context = ApplicationProcessChain.getRuleRuntimeContext();
        return context.getParams().get(returnParamName);
    }

    private RuntimeNodeParams bindingRuntimeNodeParams(RuleTemplateParamsEntity templateParam) {
        boolean nullable = templateParam.getNullable();
        String paramDesc = templateParam.getParamDesc();
        String paramName = templateParam.getParamName();
        String paramType = templateParam.getParamType();
        Integer type = templateParam.getType();
        RuntimeNodeParams param = new RuntimeNodeParams();
        param.setContextParamName(paramName);
        param.setNullable(nullable);
        param.setParamDesc(paramDesc);
        param.setParamType(paramType);
        param.setTemplateParamName(paramName);
        param.setType(type);
        return param;
    }

    @Override
    public void process(RuntimeNode currentNode) {
        this.process(currentNode, null);
    }

    @Override
    public void process(RuntimeNode currentNode, Map<String, Object> params) {
        RuleRuntimeContext context = ApplicationProcessChain.getRuleRuntimeContext();
        Validate.notNull((Object)context, (String)"\u5f53\u524d\u8fd0\u884c\u7684\u8282\u70b9\u5b9a\u4e49\u672a\u53d1\u73b0\u8fd0\u884c\u4e0a\u4e0b\u6587\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String code = currentNode.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u5f53\u524d\u8fd0\u884c\u7684\u8282\u70b9\u5b9a\u4e49\u672a\u53d1\u73b0\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, Object> contentMap = context.getParams();
        if (!CollectionUtils.isEmpty(params)) {
            contentMap.putAll(params);
        }
        Set<RuntimeNodeParams> inputParams = currentNode.getInputs();
        HashMap<String, Object> inputParamValues = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(inputParams)) {
            inputParams.forEach(item -> {
                String contextParamName = item.getContextParamName();
                String fixValue = item.getFixedValue();
                String paramType = item.getParamType();
                Object paramValue = null;
                if (!StringUtils.isBlank((CharSequence)fixValue)) {
                    try {
                        paramValue = this.parseValue(fixValue, paramType);
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException(String.format("\u56fa\u5b9a\u503c\u8f6c\u6362\u51fa\u73b0\u95ee\u9898[%s]\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u5b9a\u4e49\u4e2d\u8282\u70b9[%s]\u7684\u56fa\u5b9a\u5165\u53c2\u8bbe\u7f6e\u3002", e.getMessage(), code));
                    }
                } else {
                    paramValue = contentMap.get(contextParamName);
                }
                if (paramValue == null && item.getNullable().booleanValue()) {
                    throw new IllegalArgumentException(String.format("\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u5fc5\u987b\u4f20\u5165\u7684\u5165\u53c2[%s]\uff0c\u8bf7\u68c0\u67e5!!", code, contextParamName));
                }
                String templateParamName = item.getTemplateParamName();
                inputParamValues.put(templateParamName, paramValue);
            });
        }
        Integer sourceType = currentNode.getSourceType();
        ProcessExecutor currentProcessExecutor = null;
        for (ProcessExecutor processExecutor : this.processExecutors) {
            if (processExecutor.getSourceType() != sourceType.intValue()) continue;
            currentProcessExecutor = processExecutor;
            break;
        }
        Validate.notNull((Object)currentProcessExecutor, (String)"\u89e3\u6790\u8282\u70b9\u5b9a\u4e49[%s]\u7684\u5904\u7406\u6e90\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684sourceType\u7c7b\u578b\u503c[%d]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code, sourceType});
        currentProcessExecutor.execute(currentNode, inputParamValues, context);
    }

    private Object parseValue(String fixValue, String type) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"long")) {
            return Long.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"int")) {
            return Integer.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"float")) {
            return Float.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"boolean")) {
            return Boolean.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"double")) {
            return Double.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"short")) {
            return Short.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"short")) {
            return Byte.valueOf(fixValue);
        }
        return fixValue;
    }
}

