/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.process.executor;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;
import com.bizunited.platform.mars.service.process.RuntimeDefinitionService;
import com.bizunited.platform.mars.service.process.RuntimeNodeService;
import com.bizunited.platform.mars.service.process.executor.ProcessExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dynamicGroovyScriptProcessExecutor")
public class DynamicGroovyScriptProcessExecutor
implements ProcessExecutor {
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeDefinitionService runtimeDefinitionService;
    @Autowired
    private ScriptService scriptService;
    private static final String SCRIPT_CONTENT_PARAM = "_script";

    @Override
    public int getSourceType() {
        return 5;
    }

    @Override
    public void execute(RuntimeNode currentNode, Map<String, Object> inputParamValues, RuleRuntimeContext context) {
        Validate.notNull((Object)currentNode, (String)"\u5728\u8fdb\u884c\u8282\u70b9\u5b9a\u4e49\u6267\u884c\u65f6\uff0c\u5fc5\u987b\u8981\u6709\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u5b9a\u4e49RuntimeNode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2!!", (Object[])new Object[0]);
        String code = currentNode.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u5728\u8fdb\u884c\u8282\u70b9\u5b9a\u4e49\u6267\u884c\u65f6\uff0c\u8282\u70b9\u5b9a\u4e49\u7684code\u5fc5\u987b\u6709\u503c\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2!!", (Object[])new Object[0]);
        Object scriptContext = inputParamValues.get(SCRIPT_CONTENT_PARAM);
        Validate.notNull((Object)scriptContext, (String)"\u5f53\u524d\u6b63\u5728\u8fd0\u884c\u7684\u8282\u70b9[%s]\uff0c\u662f\u4e00\u4e2a\u52a8\u6001\u811a\u672c\u8282\u70b9\uff0c\u4f46\u662f\u5e76\u6ca1\u6709\u53d1\u73b0\u5165\u53c2\u540d\u4e3a_script\u7684\u811a\u672c\u4ee3\u7801\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        String scriptContextValue = scriptContext.toString();
        Validate.notBlank((CharSequence)scriptContextValue, (String)"\u5f53\u524d\u6b63\u5728\u8fd0\u884c\u7684\u8282\u70b9[%s]\uff0c\u662f\u4e00\u4e2a\u52a8\u6001\u811a\u672c\u8282\u70b9\uff0c\u4f46\u662f\u5e76\u6ca1\u6709\u53d1\u73b0\u5165\u53c2\u540d\u4e3a_script\u7684\u811a\u672c\u4ee3\u7801\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        Map<String, Object> contentMap = context.getParams();
        HashMap<String, Object> scriptInputsMap = new HashMap<String, Object>(contentMap);
        scriptInputsMap.put("runtimeNodeService", this.runtimeNodeService);
        scriptInputsMap.put("runtimeDefinitionService", this.runtimeDefinitionService);
        Object _returnValue = this.scriptService.invoke(scriptContextValue, scriptInputsMap);
        Set<RuntimeNodeParams> outputParams = currentNode.getOutputs();
        if (outputParams != null) {
            for (RuntimeNodeParams item : outputParams) {
                boolean nullable = item.getNullable();
                String contextParamName = item.getContextParamName();
                String templateParamName = item.getTemplateParamName();
                if (StringUtils.equals((CharSequence)contextParamName, (CharSequence)"_return")) {
                    contentMap.put(contextParamName, _returnValue);
                    continue;
                }
                Object variableValue = scriptInputsMap.get(templateParamName);
                if (variableValue == null && nullable) {
                    String errorMsg = String.format("\u5206\u6790\u8fd0\u884c\u8282\u70b9[%s]\u8fd4\u56de\u503c\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u51fa\u53c2[%s]\u8bbe\u5b9a\u4e3anot nullable\uff0c\u4f46\u662f\u6267\u884c\u7ed3\u679c\u5374\u6ca1\u6709\u8fd4\u56de\u503c\uff0c\u8bf7\u68c0\u67e5", code, templateParamName);
                    throw new IllegalArgumentException(errorMsg);
                }
                contentMap.put(contextParamName, variableValue);
            }
        }
    }
}

