package com.bizunited.platform.mars.service.cache;

/**
 * 规则引擎中一个具体的运行时节点出参和入参定义
 * @author yinwenjie
 */
public class RuntimeNodeParams {
  /**
   * 出参还是入参：1、入参；2、出参
   */
  private Integer type;
  /**
   * 参数中文说明
   */
  private String paramDesc;
  /**
   * 模板参数名（实参：符合变量命名格式）
   */
  private String templateParamName;
  /**
   * 上下文中的参数名（形参：符合变量命名格式）
   * 入参固定值和上下文绑定之间只能选择一种（优先选择前者）
   */
  private String contextParamName;
  /**
   * 入参固定值，
   * 入参固定值永远优先规则执行时上线文中的参数值。
   * 且入参固定值和上下文绑定之间只能选择一种（优先选择这种）
   */
  private String fixedValue;
  /**
   * 参数类型（八大类型、字符串、Object、Collections）：</br>
   * chart、long、int、float、boolean、double、short、byte、string、object、collection
   */
  private String paramType;
  /**
   * 参数是否可为null。如果不能为null，则会进行判定
   */
  private Boolean nullable;
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public String getParamDesc() {
    return paramDesc;
  }
  public void setParamDesc(String paramDesc) {
    this.paramDesc = paramDesc;
  }
  public String getTemplateParamName() {
    return templateParamName;
  }
  public void setTemplateParamName(String templateParamName) {
    this.templateParamName = templateParamName;
  }
  public String getContextParamName() {
    return contextParamName;
  }
  public void setContextParamName(String contextParamName) {
    this.contextParamName = contextParamName;
  }
  public String getParamType() {
    return paramType;
  }
  public void setParamType(String paramType) {
    this.paramType = paramType;
  }
  public Boolean getNullable() {
    return nullable;
  }
  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }
  public String getFixedValue() {
    return fixedValue;
  }
  public void setFixedValue(String fixedValue) {
    this.fixedValue = fixedValue;
  }
}