package com.bizunited.platform.mars.service.process;

import java.util.Map;

import com.bizunited.platform.mars.service.cache.RuntimeDefinition;
import com.bizunited.platform.mars.service.cache.RuntimeNode;

/**
 * 则实例运行所需要的完整规则节点信息，在这里被进行查询、操作和缓存
 * @author yinwenjie
 */
public interface RuntimeNodeService {
  /**
   * 根据当前规则运行时信息，寻找这个对着定义的开始节点
   * @param code 指定的规则定义编号
   * @param version 指定的规则定义版本
   * @return
   */
  RuntimeNode findStartByCodeAndVersion(RuntimeDefinition currentDefinition);
  /**
   * 根据当前的节点信息，基于当前运行的上下文信息，获取后续的运行节点信息</br>
   * 注意，这些节点都是正常规则连线场景下的后续运行时节点
   * @param processDefinition
   * @return 
   */
  RuntimeNode findNextByDefinition(RuntimeNode currentNode , RuleRuntimeContext context);
  /**
   * 根据当前的节点信息，基于当前运行的上下文信息，获取后续的运行节点信息</br>
   * 注意，这些节点都是正常规则连线场景下的后续运行时节点
   * @param processDefinition
   * @return
   */
  RuntimeNode findExceptionNextByDefinition(RuntimeNode currentNode , RuleRuntimeContext context);
  /**
   * 在当前线程存在规则执行上下文的场景下，动态的在当前正在处理的节点定义的位置（一般是通过），执行一个指定templateNodeCode的节点
   * 这个节点定义将从规则执行上下文中获取入参，并将执行后的数据按照出参要求写入到规则上下文中</p>
   * 如果执行失败，将抛出异常，且影响当前规则执行的后续执行策略
   * @param templateNodeCode 指定的节点模板业务编号
   * @param returnParamName 在处理成功结束后，从当前规则执行的上下文中的哪个key里面，提取该方法的返回信息
   */
  Object process(String templateNodeCode ,String returnParamName);
  /**
   * 在当前线程存在规则执行上下文的场景下，动态的在当前正在处理的节点定义的位置（一般是通过），执行一个指定templateNodeCode的节点
   * 这个节点定义将从规则执行上下文中获取入参，并将执行后的数据按照出参要求写入到规则上下文中</p>
   * 如果执行失败，将抛出异常，且影响当前规则执行的后续执行策略
   * @param templateNodeCode 指定的节点模板业务编号
   * @param params 可能需要的其它外部参数（可能不传入）
   * @param returnParamName 在处理成功结束后，从当前规则执行的上下文中的哪个key里面，提取该方法的返回信息
   */
  Object process(String templateNodeCode , Map<String , Object> params,String returnParamName);
  /**
   * 在当前线程存在规则执行上下文的场景下，动态的在当前正在处理的节点定义的位置（一般是通过），执行一个指定的节点定义信息
   * 这个节点定义将从规则执行上下文中获取入参，并将执行后的数据按照出参要求写入到规则上下文中</p>
   * @param currentNode 指定的节点定义信息
   */
  void process(RuntimeNode currentNode);
  /**
   * 在当前线程存在规则执行上下文的场景下，动态的在当前正在处理的节点定义的位置（一般是通过），执行一个指定的节点定义信息
   * 这个节点定义将从规则执行上下文中获取入参，并将执行后的数据按照出参要求写入到规则上下文中</p>
   * @param currentNode 指定的节点定义信息
   * @param params 可能需要的其它外部参数（可能不传入）
   */
  void process(RuntimeNode currentNode, Map<String , Object> params);
}