package com.bizunited.platform.mars.service.process.executor;

import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.service.cache.RuntimeSourceServicable;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;

/**
 * 执行器，专门用于执行逻辑处理节点的具体业务过程。该处理器设计用来执行服务源设定下的逻辑过程
 * @author yinwenjie
 */
@Component("servicableProcessExecutor")
public class ServicableProcessExecutor implements ProcessExecutor {
  @Autowired
  private ServicableMethodService servicableMethodService;
  
  public int getSourceType() {
    return 1;
  }
  public void execute(RuntimeNode currentNode , Map<String , Object> inputParamValues , RuleRuntimeContext context) {
    String code = currentNode.getCode();
    // 取得并判定处理源信息
    RuntimeSourceServicable runtimeSourceServicable = currentNode.getSourceServicable();
    Validate.notNull(runtimeSourceServicable , "运行节点[%s]时，未发现处理源信息，请检查!!" , code);
    String servicableMethod = runtimeSourceServicable.getServicableMethod();
    Validate.notBlank(servicableMethod , "运行节点[%s]时，未发现指定的服务源信息，请检查!!" , code);
    // 开始准备调用服务源
    InvokeParams invokeParams = new InvokeParams(inputParamValues);
    Object result = null;
    try {
      result = this.servicableMethodService.invoke(servicableMethod, invokeParams);
    } catch(InvokeProxyException e) {
      throw new IllegalArgumentException(e.getMessage() , e);
    }
    
    // 服务源调用成功后，视配置信息，决定将返回值写入规则上下文
    Map<String , Object> contentMap = context.getParams();
    Set<RuntimeNodeParams> outputParams = currentNode.getOutputs();
    Validate.isTrue(outputParams == null || outputParams.size() == 0  || (outputParams != null && outputParams.size() == 1) , "运行节点[%s]时，发现其设定的出参不符合要求(要么不设定返回值，要么只设置一个返回值参数)!!" , code);
    if(outputParams != null) {
      RuntimeNodeParams outputParam = outputParams.iterator().next();
      String contextParamName = outputParam.getContextParamName();
      contentMap.put(contextParamName, result);
    }
  }
}
