/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.process;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleNodeNextsEntity;
import com.bizunited.platform.mars.entity.RuleNodeParamsEntity;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.service.RuleDefinitionService;
import com.bizunited.platform.mars.service.RuleNodeEntityService;
import com.bizunited.platform.mars.service.RuleNodeNextsEntityService;
import com.bizunited.platform.mars.service.RuleNodeParamsEntityService;
import com.bizunited.platform.mars.service.RuleTemplateNodeEntityService;
import com.bizunited.platform.mars.service.cache.RuntimeDefinition;
import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.service.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.service.process.AbstractRuntimeService;
import com.bizunited.platform.mars.service.process.ApplicationProcessChain;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;
import com.bizunited.platform.mars.service.process.RuntimeDefinitionService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.ExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="SimpleRuntimeDefinitionService")
public class SimpleRuntimeDefinitionService
extends AbstractRuntimeService
implements RuntimeDefinitionService {
    @Autowired
    private RuleDefinitionService ruleDefinitionService;
    @Autowired
    private RuleNodeEntityService ruleNodeService;
    @Autowired
    private RuleNodeNextsEntityService ruleNodeNextsService;
    @Autowired
    private RuleNodeParamsEntityService ruleNodeParamsService;
    @Autowired
    private RuleTemplateNodeEntityService ruleTemplateNodeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private ApplicationContext applicationContext;
    private static Cache<String, RuntimeDefinition> cached;
    private static Map<String, ReentrantLock> runtimeDefinitionQueryLocks;
    private static final String PRE = "_MARS";
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleRuntimeDefinitionService() {
        Class<SimpleRuntimeDefinitionService> clazz = SimpleRuntimeDefinitionService.class;
        synchronized (SimpleRuntimeDefinitionService.class) {
            while (cached == null) {
                ResourcePools resourcePools = ResourcePoolsBuilder.heap((long)500L).build();
                ExpiryPolicy expiryPolicy = ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(5L));
                CacheConfigurationBuilder cacheConfigurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, RuntimeDefinition.class, (ResourcePools)resourcePools);
                CacheConfiguration cacheConfiguration = cacheConfigurationBuilder.withExpiry(expiryPolicy).build();
                CacheManagerBuilder build = CacheManagerBuilder.newCacheManagerBuilder();
                CacheManager cacheManager = build.withCache("preConfigured", cacheConfiguration).withDefaultSizeOfMaxObjectSize(1024L, MemoryUnit.MB).build(true);
                cached = cacheManager.getCache("preConfigured", String.class, RuntimeDefinition.class);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeDefinition findDetailsByCodeAndVersion(String code, String version) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)version)) {
            return null;
        }
        RuntimeDefinition cacheRuntimeDefinition = this.findCacheByCodeAndVersion(code, version);
        if (cacheRuntimeDefinition != null) {
            LOGGER.info("// === \u4ece\u7f13\u5b58\u4e2d\u52a0\u8f7d!!cacheRuntimeDefinition = " + code);
            return cacheRuntimeDefinition;
        }
        String key = StringUtils.join((Object[])new String[]{PRE, "_", code, "_", version});
        Class<SimpleRuntimeDefinitionService> clazz = SimpleRuntimeDefinitionService.class;
        synchronized (SimpleRuntimeDefinitionService.class) {
            while (runtimeDefinitionQueryLocks.get(key) == null) {
                runtimeDefinitionQueryLocks.put(key, new ReentrantLock());
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            ReentrantLock lock = null;
            try {
                lock = runtimeDefinitionQueryLocks.get(key);
                lock.lock();
                cacheRuntimeDefinition = this.findCacheByCodeAndVersion(code, version);
                if (cacheRuntimeDefinition != null) {
                    LOGGER.info("// === \u4ece\u7f13\u5b58\u4e2d\u52a0\u8f7d!!cacheRuntimeDefinition = " + code);
                    RuntimeDefinition runtimeDefinition = cacheRuntimeDefinition;
                    return runtimeDefinition;
                }
                RuntimeDefinition runtimeDefinition = this.queryDetails(code, version);
                if (runtimeDefinition == null) {
                    RuntimeDefinition runtimeDefinition2 = null;
                    return runtimeDefinition2;
                }
                this.onDefinitionCreate(runtimeDefinition);
                RuntimeDefinition runtimeDefinition3 = runtimeDefinition;
                return runtimeDefinition3;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    private RuntimeDefinition queryDetails(String code, String version) {
        RuleDefinitionEntity ruleDefinition = this.ruleDefinitionService.findDetailsByCodeAndVersion(code, version);
        if (ruleDefinition == null) {
            return null;
        }
        RuntimeDefinition runtimeDefinition = (RuntimeDefinition)this.nebulaToolkitService.copyObjectByWhiteList((Object)ruleDefinition, RuntimeDefinition.class, HashSet.class, ArrayList.class, new String[]{"nodes", "nodes.templateNode", "nodes.inputs", "nodes.outputs"});
        Set<RuntimeNode> runTimeNodes = runtimeDefinition.getNodes();
        if (CollectionUtils.isEmpty(runTimeNodes)) {
            return runtimeDefinition;
        }
        block6: for (RuntimeNode runtimeNode : runTimeNodes) {
            String runtimeNodeId = runtimeNode.getId();
            RuleNodeEntity currentRuleNode = ruleDefinition.getNodes().stream().filter(ruleNodeItem -> StringUtils.equals((CharSequence)ruleNodeItem.getId(), (CharSequence)runtimeNodeId)).findFirst().orElse(null);
            String ruleCode = currentRuleNode.getCode();
            RuleTemplateNodeEntity currentRuleTemplateNode = currentRuleNode.getTemplateNode();
            runtimeNode.setTemplateNodeId(currentRuleTemplateNode.getId());
            runtimeNode.setRuleableClass(currentRuleTemplateNode.getRuleableClass());
            int type = runtimeNode.getType();
            if (type != 2) continue;
            int sourceType = runtimeNode.getSourceType();
            switch (sourceType) {
                case 1: {
                    runtimeNode.setSourceServicable(super.parseByRuntimeSourceServicable(currentRuleTemplateNode, ruleCode));
                    continue block6;
                }
                case 2: {
                    runtimeNode.setSourceAggregateDataView(super.parseByRuntimeSourceAggregateDataView(currentRuleTemplateNode, ruleCode));
                    continue block6;
                }
                case 3: {
                    runtimeNode.setSourceScript(super.parseByRuntimeSourceScript(currentRuleTemplateNode, ruleCode));
                    continue block6;
                }
                case 5: {
                    continue block6;
                }
            }
            throw new IllegalArgumentException(String.format("\u89e3\u6790\u8282\u70b9\u5b9a\u4e49[%s]\u7684\u5904\u7406\u6e90\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684sourceType\u7c7b\u578b\u503c\uff0c\u8bf7\u68c0\u67e5!!", ruleCode));
        }
        runTimeNodes.stream().forEach(runTimeNode -> {
            String runTimeNodeId = runTimeNode.getId();
            Set nexts = this.ruleNodeNextsService.findDetailsByFromNode(runTimeNodeId);
            HashSet<RuntimeNodeNexts> runtimeNexts = new HashSet<RuntimeNodeNexts>();
            if (nexts != null) {
                nexts.stream().forEach(nextItem -> {
                    String fromNodeId = nextItem.getFromNode().getId();
                    String toNodeId = nextItem.getToNode().getId();
                    String toNodeCode = nextItem.getToNode().getCode();
                    String conditions = nextItem.getConditions();
                    Integer lineType = nextItem.getLineType();
                    Integer sort = nextItem.getSort();
                    String exceptions = nextItem.getExceptions();
                    if (runTimeNodes.stream().filter(item -> item.getId() == fromNodeId).count() == 0L) {
                        throw new IllegalArgumentException(String.format("\u6b63\u5728\u6784\u5efa\u89c4\u5219\u5b9a\u4e49\uff0c\u4f46\u662f\u672a\u53d1\u73b0\u5f53\u524d\u8fde\u7ebf\u7684\u5f00\u59cb\u8282\u70b9[%s]\uff0c\u5e76\u4e0d\u5728\u6570\u636e\u6301\u4e45\u5c42\u67e5\u8be2\u5230\u7684node\u8282\u70b9id\u4fe1\u606f", fromNodeId));
                    }
                    if (runTimeNodes.stream().filter(item -> item.getId() == toNodeId).count() == 0L) {
                        throw new IllegalArgumentException(String.format("\u6b63\u5728\u6784\u5efa\u89c4\u5219\u5b9a\u4e49\uff0c\u4f46\u662f\u672a\u53d1\u73b0\u5f53\u524d\u8fde\u7ebf\u7684\u7ed3\u675f\u8282\u70b9[%s]\uff0c\u5e76\u4e0d\u5728\u6570\u636e\u6301\u4e45\u5c42\u67e5\u8be2\u5230\u7684node\u8282\u70b9id\u4fe1\u606f", toNodeId));
                    }
                    RuntimeNodeNexts runtimeNext = new RuntimeNodeNexts();
                    runtimeNext.setConditions(conditions);
                    runtimeNext.setExceptions(exceptions);
                    runtimeNext.setLineType(lineType);
                    runtimeNext.setSort(sort);
                    runtimeNext.setToNodeCode(toNodeCode);
                    runtimeNexts.add(runtimeNext);
                });
            }
            runTimeNode.setNexts(runtimeNexts);
        });
        return runtimeDefinition;
    }

    private RuntimeDefinition findCacheByCodeAndVersion(String code, String version) {
        String key = StringUtils.join((Object[])new String[]{PRE, "_", code, "_", version});
        RuntimeDefinition runtimeDefinition = (RuntimeDefinition)cached.get((Object)key);
        return runtimeDefinition;
    }

    private void onDefinitionCreate(RuntimeDefinition runtimeDefinition) {
        if (runtimeDefinition == null) {
            return;
        }
        String code = runtimeDefinition.getCode();
        String version = runtimeDefinition.getCverion();
        String key = StringUtils.join((Object[])new String[]{PRE, "_", code, "_", version});
        cached.put((Object)key, (Object)runtimeDefinition);
    }

    @Override
    @Transactional
    public RuntimeDefinition create(RuntimeDefinition definition, byte[] fileContent) {
        Validate.notNull((Object)definition, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5b9a\u4e49\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((fileContent != null && fileContent.length > 0 ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u9875\u9762\u5e03\u5c40\u6587\u4ef6\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String code = definition.getCode();
        String version = definition.getCverion();
        String desc = definition.getDesc();
        String id = definition.getId();
        Validate.isTrue((id == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5176id\u4fe1\u606f\u4e0d\u80fd\u6709\u503c!!", (Object[])new Object[0]);
        definition.setId(null);
        Validate.notBlank((CharSequence)desc, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5176desc\u63cf\u8ff0\u4fe1\u606f\u4e0d\u80fd\u6709\u503c!!", (Object[])new Object[0]);
        RuleDefinitionEntity exsitRuleDefinition = this.ruleDefinitionService.findByCodeAndVersion(code, version);
        Validate.isTrue((exsitRuleDefinition == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u6307\u5b9a\u7684code\u3010%s\u3011\u548cversion\u3010%s\u3011\u5df2\u7ecf\u5b58\u5728\u4e8e\u89c4\u5219\u5b9a\u4e49\u4e2d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a", (Object[])new Object[]{code, version});
        Set<RuntimeNode> nodes = definition.getNodes();
        Validate.isTrue((!CollectionUtils.isEmpty(nodes) ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u672a\u53d1\u73b0\u4efb\u4f55\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        long startNodeCount = nodes.stream().filter(item -> item.getType() == 4).count();
        long endNodeCount = nodes.stream().filter(item -> item.getType() == 5).count();
        Validate.isTrue((startNodeCount == 1L ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e2d\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((endNodeCount >= 1L ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e2d\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u7ed3\u675f\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relativePath = this.saveScriptContent();
        String fileName = StringUtils.join((Object[])new String[]{code, "_", version, ".txt"});
        this.venusFileService.saveFile(relativePath, fileName, fileName, fileContent);
        definition.setTemplateFilename(fileName);
        definition.setTemplateRelativepath(relativePath);
        RuleDefinitionEntity ruleDefinition = (RuleDefinitionEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)definition, RuleDefinitionEntity.class, HashSet.class, ArrayList.class, new String[0]);
        RuleDefinitionEntity newDefinition = this.ruleDefinitionService.create(ruleDefinition);
        definition.setId(newDefinition.getId());
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        HashMap<String, RuleNodeEntity> nodeCodeMapping = new HashMap<String, RuleNodeEntity>();
        nodes.stream().forEach(node -> {
            this.validateAndHandRuntimeNode(ruleDefinition, (RuntimeNode)node, classLoader, (Map<String, RuleNodeEntity>)nodeCodeMapping);
            this.validateAndHandRuntimeNodeParams(ruleDefinition, (RuntimeNode)node, (Map<String, RuleNodeEntity>)nodeCodeMapping);
        });
        this.validateAndHandNexts(nodes, nodeCodeMapping);
        return definition;
    }

    private void validateAndHandRuntimeNode(RuleDefinitionEntity ruleDefinition, RuntimeNode node, ClassLoader classLoader, Map<String, RuleNodeEntity> nodeCodeMapping) {
        String nodeId = node.getId();
        Validate.isTrue((nodeId == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u5176id\u4fe1\u606f\u4e0d\u80fd\u6709\u503c!!", (Object[])new Object[0]);
        node.setId(null);
        String nodeCode = node.getCode();
        String templateNodeId = node.getTemplateNodeId();
        Validate.notBlank((CharSequence)templateNodeId, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u5176\u4f7f\u7528\u7684\u8282\u70b9\u6a21\u677f\u7f16\u53f7\u9700\u8981\u6307\u5b9a", (Object[])new Object[0]);
        RuleTemplateNodeEntity templateNode = this.ruleTemplateNodeService.findDetailsById(templateNodeId);
        Validate.notNull((Object)templateNode, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u8282\u70b9\u6a21\u677f\u4fe1\u606f[%s]", (Object[])new Object[]{templateNodeId});
        Validate.isTrue((templateNode.getNodeStatus() == 1 ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        RuleNodeEntity exsitRuleNode = this.ruleNodeService.findByCode(nodeCode);
        Validate.isTrue((exsitRuleNode == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u91cd\u590d\u7684\u8282\u70b9\u5b9a\u4e49code\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer type = node.getType();
        Validate.notNull((Object)type, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u8282\u70b9\u7c7b\u578b\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.isTrue((type == templateNode.getType() ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u5b9a\u4e49\u7684\u7c7b\u578b\u548c\u5bf9\u5e94\u7684\u6a21\u677f\u8282\u70b9\u4e2d\u7684\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        if (type == 2) {
            Integer sourceType = node.getSourceType();
            Validate.notNull((Object)sourceType, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u8282\u70b9\u5de5\u4f5c\u903b\u8f91\u7c7b\u578b\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
            Validate.isTrue((sourceType == templateNode.getSourceType() ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u5b9a\u4e49\u7684\u6570\u636e\u6e90\u7c7b\u578b\u548c\u5bf9\u5e94\u7684\u6a21\u677f\u8282\u70b9\u4e2d\u7684\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        }
        String ruleableClass = node.getRuleableClass();
        Validate.notBlank((CharSequence)ruleableClass, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u5176\u5b8c\u6574\u5904\u7406\u5668\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)ruleableClass, (CharSequence)templateNode.getRuleableClass()), (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u5b9a\u4e49\u7684\u7c7b\u578b\u548c\u5bf9\u5e94\u7684\u6a21\u677f\u8282\u70b9\u4e2d\u7684\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        try {
            Class.forName(ruleableClass, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            String errorMsg = String.format("\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5904\u7406\u5668[%s]\uff0c\u8bf7\u68c0\u67e5!!", ruleableClass);
            throw new IllegalArgumentException(errorMsg, e);
        }
        node.setRuleableClass(ruleableClass);
        RuleNodeEntity ruleNode = (RuleNodeEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)node, RuleNodeEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ruleNode.setTemplateNode(templateNode);
        ruleNode.setDefinition(ruleDefinition);
        ruleNode = this.ruleNodeService.create(ruleNode);
        node.setId(ruleNode.getId());
        nodeCodeMapping.put(nodeCode, ruleNode);
    }

    private void validateAndHandRuntimeNodeParams(RuleDefinitionEntity ruleDefinition, RuntimeNode node, Map<String, RuleNodeEntity> nodeCodeMapping) {
        long count;
        String templateNodeId = node.getTemplateNodeId();
        String nodeCode = node.getCode();
        RuleTemplateNodeEntity templateNode = this.ruleTemplateNodeService.findDetailsById(templateNodeId);
        Set inputTemplates = templateNode.getInputs();
        Set outputTemplates = templateNode.getOutputs();
        Set<Object> inputs = node.getInputs() == null ? new HashSet() : node.getInputs();
        Set<Object> outputs = node.getOutputs() == null ? new HashSet() : node.getOutputs();
        Set inputTemplateParamNames = inputs.stream().map(RuntimeNodeParams::getTemplateParamName).collect(Collectors.toSet());
        Set outputTemplateParamNames = outputs.stream().map(RuntimeNodeParams::getTemplateParamName).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty((Collection)inputTemplates)) {
            count = inputTemplates.stream().filter(item -> inputTemplateParamNames.contains(item.getParamName())).count();
            Validate.isTrue((count == (long)inputTemplates.size() && inputs.size() == inputTemplates.size() ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u6a21\u677f\u8bbe\u5b9a\u7684\u5165\u53c2\uff0c\u5728\u8282\u70b9\u5b9a\u4e49\u4e2d\u5e76\u6ca1\u6709\u7ed1\u5b9a\u4e0a\u4e0b\u6587\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        if (!CollectionUtils.isEmpty((Collection)outputTemplates)) {
            count = outputTemplates.stream().filter(item -> outputTemplateParamNames.contains(item.getParamName())).count();
            Validate.isTrue((count == (long)outputTemplates.size() && outputs.size() == outputTemplates.size() ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u6a21\u677f\u8bbe\u5b9a\u7684\u51fa\u53c2\uff0c\u5728\u8282\u70b9\u5b9a\u4e49\u4e2d\u5e76\u6ca1\u6709\u7ed1\u5b9a\u4e0a\u4e0b\u6587\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        inputs.stream().forEach(inputItem -> {
            String paramDesc = inputItem.getParamDesc();
            String paramType = inputItem.getParamType();
            String templateParamName = inputItem.getTemplateParamName();
            inputItem.setType(1);
            Validate.notBlank((CharSequence)paramDesc, (String)"\u5165\u53c2\u6570\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)templateParamName, (String)"\u5165\u53c2\u3010\u5b9e\u53c2\u3011-\u6a21\u677f\u53c2\u6570\u540d\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.notNull((Object)paramType, (String)"\u5165\u53c2\u6570\u7c7b\u578b\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            RuleNodeParamsEntity paramEntity = (RuleNodeParamsEntity)this.nebulaToolkitService.copyObjectByWhiteList(inputItem, RuleNodeParamsEntity.class, HashSet.class, ArrayList.class, new String[0]);
            paramEntity.setNode((RuleNodeEntity)nodeCodeMapping.get(nodeCode));
            this.ruleNodeParamsService.create(paramEntity);
        });
        outputs.stream().forEach(outputItem -> {
            String paramDesc = outputItem.getParamDesc();
            String paramType = outputItem.getParamType();
            String templateParamName = outputItem.getTemplateParamName();
            outputItem.setType(2);
            Validate.notBlank((CharSequence)paramDesc, (String)"\u51fa\u53c2\u6570\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)templateParamName, (String)"\u51fa\u53c2\u3010\u5b9e\u53c2\u3011-\u6a21\u677f\u53c2\u6570\u540d\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.notNull((Object)paramType, (String)"\u51fa\u53c2\u6570\u7c7b\u578b\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            RuleNodeParamsEntity paramEntity = (RuleNodeParamsEntity)this.nebulaToolkitService.copyObjectByWhiteList(outputItem, RuleNodeParamsEntity.class, HashSet.class, ArrayList.class, new String[0]);
            paramEntity.setNode((RuleNodeEntity)nodeCodeMapping.get(nodeCode));
            this.ruleNodeParamsService.create(paramEntity);
        });
    }

    private void validateAndHandNexts(Set<RuntimeNode> nodes, Map<String, RuleNodeEntity> nodeCodeMapping) {
        nodes.stream().forEach(node -> {
            Integer type = node.getType();
            String nodeCode = node.getCode();
            Set<Object> nexts = node.getNexts() == null ? new HashSet() : node.getNexts();
            Set normalNexts = nexts.stream().filter(item -> item.getLineType() == 1).collect(Collectors.toSet());
            RuleNodeEntity fromNode = (RuleNodeEntity)nodeCodeMapping.get(node.getCode());
            String fromNodeCode = fromNode.getCode();
            switch (type) {
                case 1: {
                    Validate.isTrue((normalNexts.size() >= 1 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u5b9a\u4e49,\u5176\u81f3\u5c11\u6709\u4e00\u4e2a\uff08\u6b63\u5e38\u7684\uff09\u540e\u7eed\u5206\u652f\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                    break;
                }
                case 5: {
                    Validate.isTrue((normalNexts == null || normalNexts.size() == 0 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u5b9a\u4e49,\u5176\u4e0d\u80fd\u6709\u4efb\u4f55\uff08\u6b63\u5e38\u7684\uff09\u540e\u7eed\u5206\u652f\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                    break;
                }
                default: {
                    Validate.isTrue((normalNexts.size() == 1 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u5b9a\u4e49,\u5176\u5fc5\u987b\u6709\u4e00\u4e2a\uff08\u6b63\u5e38\u7684\uff09\u540e\u7eed\u5206\u652f\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                }
            }
            nexts.stream().forEach(nextItem -> {
                String conditions = nextItem.getConditions();
                String exceptions = nextItem.getExceptions();
                Integer lineType = nextItem.getLineType();
                Integer sort = nextItem.getSort() == null ? 100 : nextItem.getSort();
                String toNodeCode = nextItem.getToNodeCode();
                RuleNodeEntity toNode = (RuleNodeEntity)nodeCodeMapping.get(toNodeCode);
                Validate.notNull((Object)toNode, (String)"\u6307\u5b9a\u7684\u76ee\u6807\u5b9a\u4e49\u8282\u70b9[%s]\u672a\u88ab\u53d1\u73b0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{toNodeCode});
                RuleNodeNextsEntity exsitNext = this.ruleNodeNextsService.findByFromAndTo(fromNodeCode, toNodeCode);
                Validate.isTrue((exsitNext == null ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u8fde\u7ebf\u4ece[%s]\u5230[%s]\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{fromNodeCode, toNodeCode});
                RuleNodeNextsEntity ruleNext = new RuleNodeNextsEntity();
                ruleNext.setConditions(conditions);
                ruleNext.setExceptions(exceptions);
                ruleNext.setFromNode(fromNode);
                ruleNext.setToNode(toNode);
                ruleNext.setLineType(lineType);
                ruleNext.setSort(sort);
                this.ruleNodeNextsService.create(ruleNext);
            });
        });
    }

    @Override
    @Transactional
    public RuntimeDefinition update(RuntimeDefinition definition, byte[] fileContent) {
        Validate.notNull((Object)definition, (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5b9a\u4e49\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((fileContent != null && fileContent.length > 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u9875\u9762\u5e03\u5c40\u6587\u4ef6\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String desc = definition.getDesc();
        String definitionId = definition.getId();
        Validate.notBlank((CharSequence)definitionId, (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5176id\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)desc, (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5176desc\u63cf\u8ff0\u4fe1\u606f\u4e0d\u80fd\u6ca1\u6709\u503c!!", (Object[])new Object[0]);
        RuleDefinitionEntity exsitRuleDefinition = this.ruleDefinitionService.findById(definitionId);
        Validate.notNull((Object)exsitRuleDefinition, (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u6307\u5b9a\u7684\u89c4\u5219\u5b9a\u4e49\u672a\u627e\u5230[%s]\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a", (Object[])new Object[]{definitionId});
        Set<RuntimeNode> nodes = definition.getNodes();
        long startNodeCount = nodes.stream().filter(item -> item.getType() == 4).count();
        long endNodeCount = nodes.stream().filter(item -> item.getType() == 5).count();
        Validate.isTrue((startNodeCount == 1L ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e2d\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((endNodeCount >= 1L ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e2d\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u7ed3\u675f\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set ruleNodes = this.ruleNodeService.findDetailsByDefinition(definitionId);
        if (!CollectionUtils.isEmpty((Collection)ruleNodes)) {
            Set<String> ruleNodeIds = ruleNodes.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            this.ruleNodeParamsService.deleteByRuleNodes(ruleNodeIds.toArray(new String[0]));
            this.ruleNodeNextsService.deleteByFromNodes(ruleNodeIds.toArray(new String[0]));
            this.ruleNodeService.deleteByIds(ruleNodeIds.toArray(new String[0]));
        }
        String relativePath = this.saveScriptContent();
        String fileName = StringUtils.join((Object[])new String[]{exsitRuleDefinition.getCode(), "_", exsitRuleDefinition.getCverion(), ".txt"});
        this.venusFileService.saveFile(relativePath, fileName, fileName, fileContent);
        definition.setTemplateFilename(fileName);
        definition.setTemplateRelativepath(relativePath);
        RuleDefinitionEntity ruleDefinition = (RuleDefinitionEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)definition, RuleDefinitionEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.ruleDefinitionService.update(ruleDefinition);
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        HashMap<String, RuleNodeEntity> nodeCodeMapping = new HashMap<String, RuleNodeEntity>();
        nodes.stream().forEach(node -> {
            this.validateAndHandRuntimeNode(ruleDefinition, (RuntimeNode)node, classLoader, (Map<String, RuleNodeEntity>)nodeCodeMapping);
            this.validateAndHandRuntimeNodeParams(ruleDefinition, (RuntimeNode)node, (Map<String, RuleNodeEntity>)nodeCodeMapping);
        });
        this.validateAndHandNexts(nodes, nodeCodeMapping);
        return definition;
    }

    private String saveScriptContent() {
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/ruleengine/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        return relativePath;
    }

    @Override
    public Object process(String code, String version, Map<String, Object> params) {
        RuntimeDefinition currentDefinition = this.findDetailsByCodeAndVersion(code, version);
        Validate.notNull((Object)currentDefinition, (String)"\u9519\u8bef\u7684\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f[code=%s;version=%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code, version});
        ApplicationProcessChain processChain = (ApplicationProcessChain)this.applicationContext.getBean(ApplicationProcessChain.class);
        processChain.setApplicationContext(this.applicationContext);
        processChain.setCurrentDefinition(currentDefinition);
        RuleRuntimeContext runtimeContext = new RuleRuntimeContext();
        processChain.doProcessNode(params, context -> runtimeContext.set_return(context.get_return()));
        return runtimeContext.get_return();
    }

    static {
        runtimeDefinitionQueryLocks = new ConcurrentHashMap<String, ReentrantLock>();
        LOGGER = LoggerFactory.getLogger(SimpleRuntimeDefinitionService.class);
    }
}

