package com.bizunited.platform.mars.service.cache;

import java.util.Set;

/**
 * 定义了一个正在运行的完整规则信息。这个规则信息基于数据持久层的多个相关entity生成
 * 但是为了运行时查询，描述结构做了一些调整
 * @author yinwenjie
 */
public class RuntimeDefinition {
  /**
   * 规则定义所对应的数据层编号
   */
  private String id;
  /**
   * 规则定义业务编号
   */
  private String code;
  /**
   * 规则定义版本
   */
  private String cverion;
  /**
   * 规则定义用途说明
   */
  private String desc;
  /**
   * 规则定义前端图形化展示结构描述文件的文件名
   */
  private String templateFilename;
  /**
   * 规则定义前端图形化展示结构描述文件的相对路径
   */
  private String templateRelativepath;
  /**
   * 该规则定义涉及到的运行时节点定义信息
   */
  private Set<RuntimeNode> nodes;
  /**
   * 最终返回值所在的规则执行上下文的那可以key值，可以不填写
   */
  private String returnParam;
  
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getCverion() {
    return cverion;
  }
  public void setCverion(String cverion) {
    this.cverion = cverion;
  }
  public String getDesc() {
    return desc;
  }
  public void setDesc(String desc) {
    this.desc = desc;
  }
  public String getTemplateFilename() {
    return templateFilename;
  }
  public void setTemplateFilename(String templateFilename) {
    this.templateFilename = templateFilename;
  }
  public String getTemplateRelativepath() {
    return templateRelativepath;
  }
  public void setTemplateRelativepath(String templateRelativepath) {
    this.templateRelativepath = templateRelativepath;
  }
  public Set<RuntimeNode> getNodes() {
    return nodes;
  }
  public void setNodes(Set<RuntimeNode> nodes) {
    this.nodes = nodes;
  }
  public String getReturnParam() {
    return returnParam;
  }
  public void setReturnParam(String returnParam) {
    this.returnParam = returnParam;
  }
}
