package com.bizunited.platform.mars.service.cache;

import java.util.Set;

/**
 * 规则引擎中一个具体的运行时节点定义
 * @author yinwenjie
 */
public class RuntimeNode {
  /**
   * 从数据层来源的节点定义id
   */
  private String id;
  /**
   * 节点定义-业务编号,全系统唯一（可能也是随机的，也可能是填写的）
   */
  private String code;
  /**
   * 对应的节点模板定义编号
   */
  private String templateNodeId;
  /**
   * 节点模板类型
   * 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件
   */
  private Integer type;
  /**
   * 只有逻辑组件（节点）一定需要处理源，其余类型的节点组件不一定需要</br>
   * 节点模板工作逻辑类型：
   * 1、服务源；2、数据视图（聚集）、3、后台脚本；4、数据权限；5、全动态脚本
   */
  private Integer sourceType;
  /**
   * 运行时规则处理器完整类名（运行时上下文一定实现了Ruleable接口）
   */
  private String ruleableClass;
  /**
   * 入参信息(可能没有，也可能有多个)
   */
  private Set<RuntimeNodeParams> inputs;
  /**
   * 出参信息(可能没有，也可能有多个)
   */
  private Set<RuntimeNodeParams> outputs;
  /**
   * 以当前运行时节点定义的连线指向
   */
  private Set<RuntimeNodeNexts> nexts;
  /**
   * 运行时所使用数据源-服务源
   */
  private RuntimeSourceServicable sourceServicable;
  /**
   * 运行时所使用数据源-数据视图（聚集）
   */
  private RuntimeSourceAggregateDataView sourceAggregateDataView;
  /**
   * 运行时所使用数据源-后端脚本
   */
  private RuntimeSourceScript sourceScript;
  
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getTemplateNodeId() {
    return templateNodeId;
  }
  public void setTemplateNodeId(String templateNodeId) {
    this.templateNodeId = templateNodeId;
  }
  public String getRuleableClass() {
    return ruleableClass;
  }
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public Integer getSourceType() {
    return sourceType;
  }
  public void setSourceType(Integer sourceType) {
    this.sourceType = sourceType;
  }
  public void setRuleableClass(String ruleableClass) {
    this.ruleableClass = ruleableClass;
  }
  public Set<RuntimeNodeParams> getInputs() {
    return inputs;
  }
  public void setInputs(Set<RuntimeNodeParams> inputs) {
    this.inputs = inputs;
  }
  public Set<RuntimeNodeParams> getOutputs() {
    return outputs;
  }
  public void setOutputs(Set<RuntimeNodeParams> outputs) {
    this.outputs = outputs;
  }
  public Set<RuntimeNodeNexts> getNexts() {
    return nexts;
  }
  public void setNexts(Set<RuntimeNodeNexts> nexts) {
    this.nexts = nexts;
  }
  public RuntimeSourceServicable getSourceServicable() {
    return sourceServicable;
  }
  public void setSourceServicable(RuntimeSourceServicable sourceServicable) {
    this.sourceServicable = sourceServicable;
  }
  public RuntimeSourceAggregateDataView getSourceAggregateDataView() {
    return sourceAggregateDataView;
  }
  public void setSourceAggregateDataView(RuntimeSourceAggregateDataView sourceAggregateDataView) {
    this.sourceAggregateDataView = sourceAggregateDataView;
  }
  public RuntimeSourceScript getSourceScript() {
    return sourceScript;
  }
  public void setSourceScript(RuntimeSourceScript sourceScript) {
    this.sourceScript = sourceScript;
  }
}