package com.bizunited.platform.mars.service.cache;

/**
 * 节点运行时处理源-数据视图（聚合）
 * @author yinwenjie
 */
public class RuntimeSourceAggregateDataView extends RuntimeSource {
  /**
   * 数据视图业务编号
   */
  private String viewCode;
  /**
   * 聚集函数对应的视图字段
   */
  private String aggregateField;
  /**
   * SQL集合函数类型：
   * 1、count；2、sum；3、avg；4、max；5、min
   */
  private Integer aggregateType;
  /**
   * 小数保留维数（默认为2）
   */
  private Integer scale = 2;
  public String getViewCode() {
    return viewCode;
  }
  public void setViewCode(String viewCode) {
    this.viewCode = viewCode;
  }
  public String getAggregateField() {
    return aggregateField;
  }
  public void setAggregateField(String aggregateField) {
    this.aggregateField = aggregateField;
  }
  public Integer getAggregateType() {
    return aggregateType;
  }
  public void setAggregateType(Integer aggregateType) {
    this.aggregateType = aggregateType;
  }
  public Integer getScale() {
    return scale;
  }
  public void setScale(Integer scale) {
    this.scale = scale;
  }
}