package com.bizunited.platform.mars.service.process;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.mars.entity.RuleSourceAggregateDataViewEntity;
import com.bizunited.platform.mars.entity.RuleSourceScriptEntity;
import com.bizunited.platform.mars.entity.RuleSourceServicableEntity;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.service.cache.RuntimeSourceAggregateDataView;
import com.bizunited.platform.mars.service.cache.RuntimeSourceScript;
import com.bizunited.platform.mars.service.cache.RuntimeSourceServicable;

/**
 * 这是一个为运行时服务实现抽象的上层父类，主要负责完成一些公共方法的共享调用，帮助减少代码的重复度
 * @author yinwenjie
 *
 */
public abstract class AbstractRuntimeService {
  @Autowired
  private ScriptService scriptService;
  /**
   * 该方法帮助下层实现类，根据当前的节点模板服务源定义信息，完成运行时服务源描述信息的组装
   * @param ruleNodeTemplate
   * @param ruleCode
   * @return
   */
  protected RuntimeSourceServicable parseByRuntimeSourceServicable(RuleTemplateNodeEntity ruleNodeTemplate , String ruleCode) {
    RuleSourceServicableEntity ruleSourceServicable = ruleNodeTemplate.getSourceServicable();
    Validate.notNull(ruleSourceServicable , "解析处理源是“服务源”的节点定义/节点模板[%s]时，未发现指定的服务源信息" , ruleCode);
    RuntimeSourceServicable runtimeSourceServicable = new RuntimeSourceServicable();
    runtimeSourceServicable.setServicableMethod(ruleSourceServicable.getServicableMethod());
    return runtimeSourceServicable;
  }
  /**
   * 该方法帮助下层实现类，根据当前的节点模板数据视图（聚集）定义信息，完成运行时数据视图（聚集）描述信息的组装
   * @param ruleNodeTemplate
   * @param ruleCode
   * @return
   */
  protected RuntimeSourceAggregateDataView parseByRuntimeSourceAggregateDataView(RuleTemplateNodeEntity ruleNodeTemplate, String ruleCode) {
    RuleSourceAggregateDataViewEntity ruleSourceAggregateDataView = ruleNodeTemplate.getSourceAggregateDataView();
    Validate.notNull(ruleSourceAggregateDataView , "解析处理源是“数据视图（聚集）”的节点定义/节点模板[%s]时，未发现指定的数据视图信息" , ruleCode);
    String viewCode = ruleSourceAggregateDataView.getViewCode();
    Validate.notBlank(viewCode , "解析处理源是“数据视图（聚集）”的节点定义/节点模板[%s]时，未发现指定的数据视图code信息!!" , ruleCode);
    RuntimeSourceAggregateDataView runtimeSourceAggregateDataView = new RuntimeSourceAggregateDataView();
    runtimeSourceAggregateDataView.setAggregateField(ruleSourceAggregateDataView.getAggregateField());
    runtimeSourceAggregateDataView.setAggregateType(ruleSourceAggregateDataView.getAggregateType());
    runtimeSourceAggregateDataView.setScale(ruleSourceAggregateDataView.getScale());
    runtimeSourceAggregateDataView.setViewCode(viewCode);
    return runtimeSourceAggregateDataView;
  }
  /**
   * 该方法帮助下层实现类，根据当前的节点模板脚本定义信息，完成运行时脚本描述信息的组装
   * @param ruleNodeTemplate 
   * @param ruleCode 
   * @return
   */
  protected RuntimeSourceScript parseByRuntimeSourceScript(RuleTemplateNodeEntity ruleNodeTemplate, String ruleCode) {
    RuleSourceScriptEntity ruleSourceScriptEntity = ruleNodeTemplate.getSourceScript();
    Validate.notNull(ruleSourceScriptEntity , "解析处理源是“后台脚本”的节点定义/节点模板[%s]时，未发现指定的脚本信息" , ruleCode);
    ScriptEntity scriptEntity = ruleSourceScriptEntity.getScript();
    RuntimeSourceScript runtimeSourceGroovy = new RuntimeSourceScript();
    runtimeSourceGroovy.setFileCode(scriptEntity.getFileCode());
    runtimeSourceGroovy.setFileName(scriptEntity.getFileName());
    runtimeSourceGroovy.setLanguage(scriptEntity.getLanguage());
    runtimeSourceGroovy.setScriptId(scriptEntity.getId());
    String scriptContent = scriptService.findContentById(scriptEntity.getId());
    runtimeSourceGroovy.setScriptContent(scriptContent);
    return runtimeSourceGroovy;
  }
}
