package com.bizunited.platform.mars.service.process;

import java.util.Map;

/**
 * 规则引擎运行驱动
 * @author yinwenjie
 */
public interface ProcessChain {
  /**
   * 责任链的下一步调用过程，通过这种调用方式，责任链上的一个节点可以将执行权限移交给下一个执行者
   * @param invokeParams 由外部调用者或者上一个规则处理节点调用时，传入的入参信息。可以不进行传入.
   * 如果有入参传入，这些入参将被写入到执行上下文中，且上下文中原有的值将替换
   */
  default void doProcessNode(Map<String, Object> invokeParams) {
    this.doProcessNode(invokeParams, null);
  }
  
  /**
   * 责任链的下一步调用过程，通过这种调用方式，责任链上的一个节点可以将执行权限移交给下一个执行者
   * @param invokeParams 由外部调用者或者上一个规则处理节点调用时，传入的入参信息。可以不进行传入.
   * 如果有入参传入，这些入参将被写入到执行上下文中，且上下文中原有的值将替换
   * @param invocation 一旦整个调用链处理成功，最初的调用者将会通过invocation该接口的实现接收到处理成功后的规则运行时状态
   */
  default void doProcessNode(Map<String, Object> invokeParams , ProcessChainInvocation invocation) {
    this.doProcessNode(invokeParams);
  }
}
