package com.bizunited.platform.mars.service.process;

import java.util.HashMap;
import java.util.Map;

import com.bizunited.platform.mars.service.cache.RuntimeDefinition;

/**
 * 规则运行时上下文信息，不允许继承、修改，只允许在一个工作线程的范围进行使用
 * @author yinwenjie
 */
public final class RuleRuntimeContext {
  /**
   * 当前的工作线程
   */
  private Thread currentThread;
  /**
   * 当前正在运行的规则定义
   */
  private RuntimeDefinition currentDefinition;
  /**
   * 当前规则的运行状态
   */
  private RuleProcessStatus status;
  /**
   * 这个map结构存储当前上下文中的各种参数信息
   */
  private Map<String, Object> params = new HashMap<>();
  /**
   * 规则正常运行结束后的返回结果在这里存储
   */
  private Object _return;
  /**
   * 如果当前规则运行过程已经出现异常，则异常信息在这里
   */
  private Throwable currentThrowable;
  /**
   * 记录当前抛出异常的运行时节点层次（即递归深度）
   */
  private Integer exceptionLevel;
  public Thread getCurrentThread() {
    return currentThread;
  }
  public void setCurrentThread(Thread currentThread) {
    this.currentThread = currentThread;
  }
  public RuntimeDefinition getCurrentDefinition() {
    return currentDefinition;
  }
  public void setCurrentDefinition(RuntimeDefinition currentDefinition) {
    this.currentDefinition = currentDefinition;
  }
  public RuleProcessStatus getStatus() {
    return status;
  }
  public void setStatus(RuleProcessStatus status) {
    this.status = status;
  }
  public Map<String, Object> getParams() {
    return params;
  }
  public void setParams(Map<String, Object> params) {
    this.params = params;
  }
  public Object get_return() {
    return _return;
  }
  public void set_return(Object _return) {
    this._return = _return;
  }
  public Throwable getCurrentThrowable() {
    return currentThrowable;
  }
  public void setCurrentThrowable(Throwable currentThrowable) {
    this.currentThrowable = currentThrowable;
  }
  public Integer getExceptionLevel() {
    return exceptionLevel;
  }
  public void setExceptionLevel(Integer exceptionLevel) {
    this.exceptionLevel = exceptionLevel;
  }
}
