package com.bizunited.platform.mars.service.rule;

import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.process.ProcessChain;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;

/**
 * 这是一个标识接口，标记以下的实现类，都是被定义的规则描述节点</br>
 * 可能是开始节点、可能是条件节点、可能是处理节点，等等
 * @author yinwenjie
 */
@FunctionalInterface
public interface Ruleable {
  /**
   * 规则节点运行时所使用的处理器，这些处理器将通过该方法完成各自的处理逻辑。</br>
   * 规则定义的运行基于类似servlet filter的多元递归，所以在每个处理节点运行后，都应该使用类似如下代码，驱动整个规则运行过程向后流动：</p>
   * <code>
   * processChain.doProcessNode(outputs)
   * </code>
   * 
   * @param currentNode 当前正在处理的运行时节点
   * @param context 规则引擎运行时上下文
   * @param processChain 规则执行的控制器
   */
  void doProcessNode(final RuntimeNode currentNode , final RuleRuntimeContext context , final ProcessChain processChain);
}
