package com.bizunited.platform.mars.service.rule.processes;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.process.ProcessChain;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;
import com.bizunited.platform.mars.service.process.RuntimeNodeService;

/**
 * 基于服务源的
 * @author yinwenjie
 */
@Component("dataviewAggregateProcessRuleable")
public class DataviewAggregateProcessRuleable implements ProcessRuleable {

  @Autowired
  private RuntimeNodeService runtimeNodeService;
  
  @Override
  public void doProcessNode(RuntimeNode currentNode, RuleRuntimeContext context, ProcessChain processChain) {
    Integer sourceType = currentNode.getSourceType();
    if(sourceType != null) {
      runtimeNodeService.process(currentNode);
    }
    processChain.doProcessNode(null);
  }
}
