package com.bizunited.platform.mars.service.rule.processes;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.process.ProcessChain;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;
import com.bizunited.platform.mars.service.process.RuntimeNodeService;

/**
 * 基于全动态脚本的逻辑节点处理组件
 * @author yinwenjie
 */
@Component("dynamicGroovyScriptProcessRuleable")
public class DynamicGroovyScriptProcessRuleable implements ProcessRuleable {

  @Autowired
  private RuntimeNodeService runtimeNodeService;
  
  @Override
  public void doProcessNode(RuntimeNode currentNode, RuleRuntimeContext context, ProcessChain processChain) {
    Integer sourceType = currentNode.getSourceType();
    if(sourceType != null) {
      runtimeNodeService.process(currentNode);
    }
    processChain.doProcessNode(null);
  }
}