package com.bizunited.platform.mars.service.rule.processes;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.process.ProcessChain;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;
import com.bizunited.platform.mars.service.process.RuntimeNodeService;

/**
 * 基于groovy脚本的处理组件
 * @author yinwenjie
 */
@Component("groovyScriptProcessRuleable")
public class GroovyScriptProcessRuleable implements ProcessRuleable {

  @Autowired
  private RuntimeNodeService runtimeNodeService;
  
  @Override
  public void doProcessNode(RuntimeNode currentNode, RuleRuntimeContext context, ProcessChain processChain) {
    runtimeNodeService.process(currentNode);
    processChain.doProcessNode(null);
  }
}