/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.process;

import com.bizunited.platform.mars.service.cache.RuntimeDefinition;
import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.process.ProcessChain;
import com.bizunited.platform.mars.service.process.ProcessChainInvocation;
import com.bizunited.platform.mars.service.process.RuleProcessStatus;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;
import com.bizunited.platform.mars.service.process.RuntimeNodeService;
import com.bizunited.platform.mars.service.rule.Ruleable;
import com.bizunited.platform.mars.service.rule.conditions.ConditionRuleable;
import com.bizunited.platform.mars.service.rule.end.EndRuleable;
import com.bizunited.platform.mars.service.rule.mutex.MutexLockRuleable;
import com.bizunited.platform.mars.service.rule.processes.ProcessRuleable;
import com.bizunited.platform.mars.service.rule.start.StarterRuleable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Primary
@Component(value="ApplicationProcessChain")
@Scope(value="prototype")
public final class ApplicationProcessChain
implements ProcessChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationProcessChain.class);
    private static ThreadLocal<RuleRuntimeContext> ruleRuntimeContext = new ThreadLocal();
    private RuntimeDefinition currentDefinition;
    private RuntimeNode currentNode;
    private int count = 0;
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcessNode(Map<String, Object> invokeOutputs, ProcessChainInvocation invocation) {
        RuntimeNode errorNode;
        Validate.notNull((Object)this.currentDefinition, (String)"\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull((Object)this.applicationContext, (String)"\u4e0a\u4e0b\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull((Object)this.currentDefinition, (String)"\u672a\u53d1\u73b0\u8981\u8fd0\u884c\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u4e0d\u5141\u8bb8\u6267\u884c!!", (Object[])new Object[0]);
        RuntimeNodeService runtimeNodeService = (RuntimeNodeService)this.applicationContext.getBean(RuntimeNodeService.class);
        Integer currentLevel = this.count++;
        RuleRuntimeContext currentContext = ruleRuntimeContext.get();
        if (currentContext == null) {
            currentContext = new RuleRuntimeContext();
            currentContext.setStatus(RuleProcessStatus.NORMAL);
            currentContext.setCurrentDefinition(this.currentDefinition);
            currentContext.setCurrentThread(Thread.currentThread());
            if (invokeOutputs != null) {
                currentContext.setParams(new HashMap<String, Object>(invokeOutputs));
            } else {
                currentContext.setParams(new HashMap<String, Object>());
            }
            ruleRuntimeContext.set(currentContext);
        }
        if (this.currentNode == null) {
            this.currentNode = runtimeNodeService.findStartByCodeAndVersion(this.currentDefinition);
            Validate.notNull((Object)this.currentNode, (String)"\u6ca1\u6709\u627e\u5230\u89c4\u5219\u5b9a\u4e49\u7684\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        } else {
            if (this.currentNode.getType() == 5) {
                if (currentContext.getStatus() == RuleProcessStatus.EXCEPTION) {
                    throw new IllegalArgumentException(currentContext.getCurrentThrowable());
                }
                currentContext.setStatus(RuleProcessStatus.DONE);
                String returnParam = this.currentDefinition.getReturnParam();
                if (!StringUtils.isBlank((CharSequence)returnParam)) {
                    currentContext.set_return(currentContext.getParams().get(returnParam));
                }
                return;
            }
            Map<String, Object> contextParams = currentContext.getParams();
            if (!CollectionUtils.isEmpty(invokeOutputs)) {
                contextParams.putAll(invokeOutputs);
            }
        }
        if (currentLevel != 0) {
            this.currentNode = runtimeNodeService.findNextByDefinition(this.currentNode, currentContext);
            Validate.notNull((Object)this.currentNode, (String)"\u6839\u636e\u5f53\u524d\u89c4\u5219\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\uff0c\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4e0b\u4e00\u8fd0\u884c\u65f6\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        Class<?> nodeRuleableClass = this.parseRuleable(this.applicationContext.getClassLoader());
        Ruleable ruleable = (Ruleable)this.applicationContext.getBean(nodeRuleableClass);
        try {
            ruleable.doProcessNode(this.currentNode, currentContext, this);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (currentContext.getStatus() == RuleProcessStatus.NORMAL) {
                Throwable currente = e;
                if (currente instanceof InvocationTargetException) {
                    currente = ((InvocationTargetException)e).getTargetException();
                }
                currentContext.setCurrentThrowable(currente);
                currentContext.setStatus(RuleProcessStatus.EXCEPTION);
                currentContext.setExceptionLevel(currentLevel);
            }
        }
        finally {
            if (currentLevel == 0) {
                String returnParam = this.currentDefinition.getReturnParam();
                if (!StringUtils.isBlank((CharSequence)returnParam)) {
                    Object returnValue = currentContext.getParams().get(returnParam);
                    if (returnValue != null) {
                        currentContext.set_return(returnValue);
                    }
                    if (invocation != null) {
                        invocation.success(currentContext);
                    }
                }
                ruleRuntimeContext.set(null);
            }
        }
        if (currentContext.getStatus() == RuleProcessStatus.EXCEPTION && currentLevel == currentContext.getExceptionLevel() && (errorNode = runtimeNodeService.findExceptionNextByDefinition(this.currentNode, currentContext)) != null) {
            this.currentNode = errorNode;
            nodeRuleableClass = this.parseRuleable(this.applicationContext.getClassLoader());
            ruleable = (Ruleable)this.applicationContext.getBean(nodeRuleableClass);
            try {
                ruleable.doProcessNode(this.currentNode, currentContext, this);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (currentContext.getStatus() == RuleProcessStatus.EXCEPTION) {
            throw new IllegalArgumentException(currentContext.getCurrentThrowable());
        }
    }

    private Class<?> parseRuleable(ClassLoader appClassLoader) {
        if (appClassLoader == null) {
            appClassLoader = this.applicationContext.getClassLoader();
        }
        Integer nodeType = this.currentNode.getType();
        String nodeRuleableClassName = this.currentNode.getRuleableClass();
        Class<?> nodeRuleableClass = null;
        try {
            nodeRuleableClass = appClassLoader.loadClass(nodeRuleableClassName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (!Ruleable.class.isAssignableFrom(nodeRuleableClass)) {
            throw new IllegalArgumentException(String.format("\u5f53\u524d\u89c4\u5219\u5904\u7406\u5668[%s]\u5e76\u6ca1\u6709\u5b9e\u73b0Ruleable\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!", nodeRuleableClass.getName()));
        }
        switch (nodeType) {
            case 1: {
                if (ConditionRuleable.class.isAssignableFrom(nodeRuleableClass)) break;
                throw new IllegalArgumentException("\u5224\u5b9a\u7ec4\u4ef6\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0ConditionRuleable\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!");
            }
            case 2: {
                if (ProcessRuleable.class.isAssignableFrom(nodeRuleableClass)) break;
                throw new IllegalArgumentException("\u903b\u8f91\u5904\u7406\u7ec4\u4ef6\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0ProcessRuleable\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!");
            }
            case 3: {
                if (MutexLockRuleable.class.isAssignableFrom(nodeRuleableClass)) break;
                throw new IllegalArgumentException("\u9501\u7ec4\u4ef6\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0ProcessRuleable\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!");
            }
            case 4: {
                if (StarterRuleable.class.isAssignableFrom(nodeRuleableClass)) break;
                throw new IllegalArgumentException("\u5f00\u59cb\u7ec4\u4ef6\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0ProcessRuleable\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!");
            }
            case 5: {
                if (EndRuleable.class.isAssignableFrom(nodeRuleableClass)) break;
                throw new IllegalArgumentException("\u7ed3\u675f\u7ec4\u4ef6\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0ProcessRuleable\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!");
            }
        }
        return nodeRuleableClass;
    }

    public static RuleRuntimeContext getRuleRuntimeContext() {
        return ruleRuntimeContext.get();
    }

    public void setCurrentDefinition(RuntimeDefinition currentDefinition) {
        this.currentDefinition = currentDefinition;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

