/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.process.executor;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.mars.service.cache.RuntimeNode;
import com.bizunited.platform.mars.service.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.service.cache.RuntimeSourceScript;
import com.bizunited.platform.mars.service.process.RuleRuntimeContext;
import com.bizunited.platform.mars.service.process.RuntimeDefinitionService;
import com.bizunited.platform.mars.service.process.RuntimeNodeService;
import com.bizunited.platform.mars.service.process.executor.ProcessExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="groovyScriptProcessExecutor")
public class GroovyScriptProcessExecutor
implements ProcessExecutor {
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeDefinitionService runtimeDefinitionService;
    @Autowired
    private ScriptService scriptService;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptProcessExecutor.class);

    @Override
    public int getSourceType() {
        return 3;
    }

    @Override
    public void execute(RuntimeNode currentNode, Map<String, Object> inputParamValues, RuleRuntimeContext context) {
        Validate.notNull((Object)currentNode, (String)"\u5728\u8fdb\u884c\u8282\u70b9\u5b9a\u4e49\u6267\u884c\u65f6\uff0c\u5fc5\u987b\u8981\u6709\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u5b9a\u4e49RuntimeNode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2!!", (Object[])new Object[0]);
        String code = currentNode.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u5728\u8fdb\u884c\u8282\u70b9\u5b9a\u4e49\u6267\u884c\u65f6\uff0c\u8282\u70b9\u5b9a\u4e49\u7684code\u5fc5\u987b\u6709\u503c\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2!!", (Object[])new Object[0]);
        RuntimeSourceScript runtimeSourceGroovy = currentNode.getSourceScript();
        Validate.notNull((Object)runtimeSourceGroovy, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u5904\u7406\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        String language = runtimeSourceGroovy.getLanguage();
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)language, (CharSequence)"groovy"), (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u53d1\u73b0\u811a\u672c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        String scriptContent = runtimeSourceGroovy.getScriptContent();
        Validate.notBlank((CharSequence)scriptContent, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u811a\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        String scriptId = runtimeSourceGroovy.getScriptId();
        Validate.notBlank((CharSequence)scriptId, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u811a\u672cId\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        inputParamValues.put("runtimeNodeService", this.runtimeNodeService);
        inputParamValues.put("runtimeDefinitionService", this.runtimeDefinitionService);
        HashMap outputParamValues = null;
        try {
            outputParamValues = this.scriptService.invoke(new String[]{scriptId}, inputParamValues);
        }
        catch (InvokeProxyException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (outputParamValues == null) {
            outputParamValues = new HashMap();
        }
        Map<String, Object> contentMap = context.getParams();
        Set<RuntimeNodeParams> outputParams = currentNode.getOutputs();
        if (outputParams != null) {
            for (RuntimeNodeParams item : outputParams) {
                boolean nullable = item.getNullable();
                String templateParamName = item.getTemplateParamName();
                String contextParamName = item.getContextParamName();
                Object outputValue = outputParamValues.get(templateParamName);
                if (outputValue == null && nullable) {
                    String errorMsg = String.format("\u5206\u6790\u8fd0\u884c\u8282\u70b9[%s]\u8fd4\u56de\u503c\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u51fa\u53c2[%s]\u8bbe\u5b9a\u4e3anot nullable\uff0c\u4f46\u662f\u6267\u884c\u7ed3\u679c\u5374\u6ca1\u6709\u8fd4\u56de\u503c\uff0c\u8bf7\u68c0\u67e5", code, templateParamName);
                    throw new IllegalArgumentException(errorMsg);
                }
                contentMap.put(contextParamName, outputValue);
            }
        }
    }
}

