package com.bizunited.platform.mars.local.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeDefinitionService;

import io.swagger.annotations.ApiOperation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 规则运行时信息相关的http restful接口定义
 * @author yinwenjei
 */
@RestController
@RequestMapping("/v1/mars/runtimeDefinitions")
public class RuntimeDefinitionController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeDefinitionController.class);
  @Autowired
  private RuntimeDefinitionService runtimeDefinitionService;

  /**
   * 对一个指定的规则定义发起请求调用（同步调用），只有当规则执行正常完成返回了结果或者异常执行抛出了运行时异常，调用者才能向后执行：</br>
   * 能够执行同步调用的规则定义有以下特点：</br>
   * 1、只有一个开始节点且只有一个唯一的结束节点</br>
   * 2、整个规则定义中没有时间等待节点，即使存在这样的节点，其节点也不能存在真实延时效果；</br>
   * 只有满足这两个要求的规则定义，才能进行同步调用，这主要是保证处理线程不被当前业务请求长期占据，导致系统响应度严重降低</br>
   * @param code 指定的规则定义的业务编号
   * @param version 指定的规则定义的版本信息
   * @param params 如果有外部的参数，则从这里进行传入
   * @return 如果当前规则定义指定了存在调用结果，在调用成功的前提下，调用结果将被返回
   */
  @ApiOperation(value = "对一个指定的规则定义发起请求调用（同步调用），只有当规则执行正常完成返回了结果或者异常执行抛出了运行时异常，调用者才能向后执行")
  @RequestMapping(value="/process" , method={RequestMethod.POST})
  public ResponseModel process(@RequestParam("code") String code ,
                               @RequestParam("version") String version , HttpServletRequest request , HttpServletResponse response) {
    try {
      // request中的param值全部通过K-V形式进行读取
      Map<String, Object> inputs = new HashMap<>();
      Map<String, String[]> parameterMap = request.getParameterMap();
      if(parameterMap != null) {
        Set<Entry<String, String[]>> entrySet = parameterMap.entrySet();
        for (Entry<String, String[]> entry : entrySet) {
          String key = entry.getKey();
          String[] values = entry.getValue();
          if(values == null) {
            continue;
          }
          if(values.length == 1) {
            inputs.put(key, values[0]);
          } else {
            inputs.put(key, values);
          }
        }
      }
      // 开始调用
      Object result = this.runtimeDefinitionService.process(code, version, inputs);
      if(result instanceof Collection<?>) {
        Collection<?> results = (Collection<?>)result;
        return this.buildHttpResultW(results);
      } else {
        return this.buildHttpResultW(result);
      }
    } catch(RuntimeException e) { 
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
} 
