package com.bizunited.platform.mars.policy.process.cache;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleNodeNextsEntity;

/**
 * 规则引擎中一个具体的运行时节点定义
 * @author yinwenjie
 */
public abstract class RuntimeNode { 
  /**
   * 从数据层来源的节点定义id
   */
  private String id;
  /**
   * 节点定义-业务编号,全系统唯一（可能也是随机的，也可能是填写的）
   */
  private String code;
  /**
   * 对应的节点模板定义编号
   */
  private String templateNodeId;
  /**
   * 该节点对应的规则运行实例号
   */
  private String instanceId;
  /**
   * 节点模板类型
   * 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、
   * 6、A/B并发组件、7、并发汇聚组件、8、时间控制组件、9、人员筛选组件
   */
  private RuntimeNodeType type;
  /**
   * 运行时规则处理器完整类名（运行时上下文一定实现了Ruleable接口）
   */
  private String ruleableClass;
  /**
   * 入参信息(可能没有，也可能有多个)
   */
  private Set<RuntimeNodeParams> inputs;
  /**
   * 出参信息(可能没有，也可能有多个)
   */
  private Set<RuntimeNodeParams> outputs;
  /**
   * 以当前运行时节点定义的连线指向
   */
  private Set<RuntimeNodeNexts> nexts;
  
  /**
   * TODO 注释未写，一定说明其与泛型的关系
   * @param <S>
   * @param <T>
   * @param targetClass
   * @param ruleNode
   * @return
   */
  protected static <S extends RuleNodeEntity , T extends RuntimeNode> T doMappingTransform(Class<T> targetClass , S ruleNode) {
    /*
     * 1、先使用中考方式，完成cache信息和entity信息相同数值型的转换
     * 2、再进行基本信息、模板信息的差异属性转换
     * 注意：目前来看出参、入参这两个关联信息，不存在不同的属性，所以就不必单独处理了
     * 3、再进行连线信息中，差异属性的转换
     * */
    // 1&2、========
    T runtimeStartNode = RuntimeNode.copyRuntimeNodeByWhiteList(ruleNode, targetClass);
    runtimeStartNode.setTemplateNodeId(ruleNode.getTemplateNode().getId());
    final String nodeCode = ruleNode.getCode();
    
    // 3、========
    Set<RuntimeNodeNexts> runtimeNodeNexts = runtimeStartNode.getNexts();
    for (RuntimeNodeNexts runtimeNodeNextItem : runtimeNodeNexts) {
      // 找到数据层对应的next entity信息
      Set<RuleNodeNextsEntity> ruleNexts = ruleNode.getNexts();
      RuleNodeNextsEntity currentNext = ruleNexts.stream().filter(item -> StringUtils.equals(nodeCode, item.getFromNode().getCode())).findFirst().orElse(null);
      runtimeNodeNextItem.setToNodeCode(currentNext.getToNode().getCode());
    }
    
    return runtimeStartNode;
  }
  
  /**
   * TODO 注释未写
   * @param <T>
   * @param ruleNode
   * @param targetClass
   */
  private static <T extends RuntimeNode> T copyRuntimeNodeByWhiteList(RuleNodeEntity ruleNode , Class<T> targetClass) {
    NebulaToolkitService nebulaToolkitService = new NebulaToolkitService();
    return nebulaToolkitService.copyObjectByWhiteList(ruleNode, targetClass, LinkedHashSet.class,ArrayList.class, new String[] {"inputs","outputs","nexts"});
  }
  
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public RuntimeNodeType getType() {
    return type;
  }
  public void setType(RuntimeNodeType type) {
    this.type = type;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getTemplateNodeId() {
    return templateNodeId;
  }
  public void setTemplateNodeId(String templateNodeId) {
    this.templateNodeId = templateNodeId;
  }
  public String getRuleableClass() {
    return ruleableClass;
  }
  public void setRuleableClass(String ruleableClass) {
    this.ruleableClass = ruleableClass;
  }
  public Set<RuntimeNodeParams> getInputs() {
    return inputs;
  }
  public void setInputs(Set<RuntimeNodeParams> inputs) {
    this.inputs = inputs;
  }
  public Set<RuntimeNodeParams> getOutputs() {
    return outputs;
  }
  public void setOutputs(Set<RuntimeNodeParams> outputs) {
    this.outputs = outputs;
  }
  public Set<RuntimeNodeNexts> getNexts() {
    return nexts;
  }
  public void setNexts(Set<RuntimeNodeNexts> nexts) {
    this.nexts = nexts;
  }
  public String getInstanceId() {
    return instanceId;
  }
  public void setInstanceId(String instanceId) {
    this.instanceId = instanceId;
  }
}