package com.bizunited.platform.mars.policy.process.cache;

/**
 * 规则引擎中的连线信息
 * @author yinwenjie
 */
public class RuntimeNodeNexts {
  /**
   * 该连接线对应的节点信息（目标节点编号）
   * 该节点一定引用至对应的RuntimeDefinition对象中的某一个RuntimeNode对象的id
   */
  private String toNodeCode;
  /**
   * 如果当前处理节点有多个连续线
   * 则连接线的判定顺序以当前设定值为准（值越小优先级越高）
   */
  private Integer sort = 100;
  /**
   * 线条类型(1：正常线；2：异常线)
   */
  private Integer lineType;
  /**
   * 流转表达式（流转条件）
   */
  private String conditions;
  /**
   * 异常线支持的完整异常类型（多个使用“,”分割）
   */
  private String exceptions;
  public String getToNodeCode() {
    return toNodeCode;
  }
  public void setToNodeCode(String toNodeCode) {
    this.toNodeCode = toNodeCode;
  }
  public Integer getSort() {
    return sort;
  }
  public void setSort(Integer sort) {
    this.sort = sort;
  }
  public Integer getLineType() {
    return lineType;
  }
  public void setLineType(Integer lineType) {
    this.lineType = lineType;
  }
  public String getConditions() {
    return conditions;
  }
  public void setConditions(String conditions) {
    this.conditions = conditions;
  }
  public String getExceptions() {
    return exceptions;
  }
  public void setExceptions(String exceptions) {
    this.exceptions = exceptions;
  }
}
