package com.bizunited.platform.mars.policy.process.cache;

import java.util.List;

import com.bizunited.platform.mars.policy.process.rule.Ruleable;

/**
 * 规则引擎中一个实例的执行过程有多个规则链路构成。由于当前版本规则引擎支持并行分支（由A/B分流节点和汇聚节点进行支持）</br>
 * 所以当一个规则实例运行起来时，就可能出现利用多个线程运行多个流程线的情况。那么当前运行的每一个流程线都需要进行记录
 * 以及流程线的上下级关系也要进行记录。这样才能保证在某条流程线，由于运行要求需要停止时，能正确通知到相关的上层流程同时进行终止。</br>
 * 
 * 注意，如果执行链存在上级链，那么上级链的最后一个节点就是本执行链的开始节点。但是本执行链并不会去执行开始节点的process过程，只是作为一个标记位
 * @author yinwenjie
 */
public class RuntimeProcessorLinked {
  /**
   * 创建规则链路时，必须规则定义中的一个规则线路进行创建
   * @param foundNext
   */
  public RuntimeProcessorLinked(RuntimeNode founder , RuntimeNodeNexts foundNext) {
    this.founder = founder;
    this.foundNext = foundNext;
  }
  /**
   * 分支上的规则节点，按执行顺序排列，越先执行的放在越前面
   */
  private List<? extends Ruleable<? extends RuntimeNode>> ruleable;
  /**
   * 该执行链的子级链路
   */
  private List<RuntimeProcessorLinked> childLinkeds;
  /**
   * 当前执行链的状态
   * RUNNABLE：正在执行或者没有任何条件阻碍当前执行链执行；
   * DONESELF：当前规则链已经执行完成，但是还有后续的规则链需要执行或者正在执行
   * DONE：当前规则链已经执行完成，且没有后续规则链需要执行
   * EXCEPTION：当前规则链在执行过程中抛出了异常
   */
  private volatile Status status;
  /**
   * 当出现异常时，当前属性记录出现异常的规则实例执行节点
   */
  private RuntimeNode exceptioner;
  /**
   * 出现异常时，当前属性记录出现异常的信息
   */
  private Throwable throwable;
  /**
   * 当前规则链路一定存在创始节点。
   * 如果当前规则链路存在上级链路，则上级链路的终结节点一定是当前链路的创始节点
   */
  private RuntimeNode founder;
  /**
   * 由当前创始节点延伸出来的第一条执行连线；记录执行连线主要是因为第一个创始节点不能被重复执行
   * 所以当前规则链路的第一个规则执行点，将是该连线指向的第二个节点
   */
  private RuntimeNodeNexts foundNext;
  /**
   * 当前正在处理的节点运行时信息
   */
  private RuntimeNode currentNode;
  /**
   * 如果当前规则链路没有运行结束，则不存在终结节点
   * 如果当前规则链路存在下级链路，则当前链路的终结节点一定是下级链路的开始创始节点
   */
  private RuntimeNode terminator;
  
  public List<? extends Ruleable<? extends RuntimeNode>> getRuleable() {
    return ruleable;
  }

  public List<RuntimeProcessorLinked> getChildLinkeds() {
    return childLinkeds;
  }

  public Status getStatus() {
    return status;
  }

  public RuntimeNode getFounder() {
    return founder;
  }

  public RuntimeNodeNexts getFoundNext() {
    return foundNext;
  }

  public RuntimeNode getTerminator() {
    return terminator;
  }

  public RuntimeNode getExceptioner() {
    return exceptioner;
  }

  public Throwable getThrowable() {
    return throwable;
  }

  void setRuleable(List<? extends Ruleable<? extends RuntimeNode>> ruleable) {
    this.ruleable = ruleable;
  }

  void setChildLinkeds(List<RuntimeProcessorLinked> childLinkeds) {
    this.childLinkeds = childLinkeds;
  }

  public void setStatus(Status status) {
    this.status = status;
  }

  void setFounder(RuntimeNode founder) {
    this.founder = founder;
  }

  void setFoundNext(RuntimeNodeNexts foundNext) {
    this.foundNext = foundNext;
  }

  public void setTerminator(RuntimeNode terminator) {
    this.terminator = terminator;
  }

  public void setExceptioner(RuntimeNode exceptioner) {
    this.exceptioner = exceptioner;
  }

  public void setThrowable(Throwable throwable) {
    this.throwable = throwable;
  }
  public RuntimeNode getCurrentNode() {
    return currentNode;
  }

  public void setCurrentNode(RuntimeNode currentNode) {
    this.currentNode = currentNode;
  }
  /**
   * 当前执行链的工作状态
   * @author yinwenjie
   */
  public enum Status {
    RUNNABLE,
    DONESELF,
    DONE,
    EXCEPTION
  }
}