package com.bizunited.platform.mars.policy.process.cache.logic;

import org.apache.commons.lang3.Validate;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleSourceDataViewEntity;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;


/**
 * 基于数据视图定义的一个具体运行时节点
 * TODO 应该会存在参数需要加入
 * @author yinwenjie
 */
public class RuntimeDataViewNode extends RuntimeLogicAble implements Mappable<RuleNodeEntity, RuntimeDataViewNode> {
  /**
   * 数据视图业务编号
   */
  private String viewCode;
  
  @Override
  public RuntimeDataViewNode mappingTransform(RuleNodeEntity ruleNode) {
    RuntimeDataViewNode runtimeDataViewNode = super.doMappingTransform(RuntimeDataViewNode.class, ruleNode);
    RuleTemplateNodeEntity ruleTemplateNode = ruleNode.getTemplateNode();
    RuleSourceDataViewEntity ruleSourceDataView = ruleTemplateNode.getSourceDataView();
    Validate.notNull(ruleSourceDataView , "未发现持久层节点模板中指定的数据视图（集合）信息，请检查!!");
    
    runtimeDataViewNode.setViewCode(ruleSourceDataView.getViewCode());
    return runtimeDataViewNode;
  }

  public String getViewCode() {
    return viewCode;
  }

  public void setViewCode(String viewCode) {
    this.viewCode = viewCode;
  }
}
