package com.bizunited.platform.mars.policy.process.cache.logic;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;

/**
 * 规则引擎支持的逻辑组件
 * @author yinwenjie
 */
public abstract class RuntimeLogicAble extends RuntimeNode {
  /**
   * 只有逻辑组件（节点）一定需要处理源，其余类型的节点组件不一定需要</br>
   * 节点模板工作逻辑类型：
   * 1、服务源；2、数据视图（聚集）、3、后台脚本；4、数据权限？；5、全动态脚本；6、数据视图（集合）
   */
  private Integer sourceType;
  /**
   * 这个逻辑组件是否使用表单引擎作为入参值输入介质
   */
  private Boolean formEngine;
  /**
   * 当前表单引擎使用的表单实例号
   */
  private String formInstanceId;
  /**
   * 这个逻辑组件是否使用列表引擎作为入参值输入介质
   */
  private Boolean listEngine;
  /**
   * 列表引擎的业务编码
   */
  private String listEngineCode;
  /**
   * 列表引擎的业务版本号
   */
  private String listEngineVersion;
  /**
   * 如果需要进行页面引擎弹窗，则这里可填写弹窗的标题信息
   */
  private String showTitle;
  /**
   * 弹窗的高度，可以是像素或者百分比
   */
  private Integer showHight;
  /**
   * 弹窗的宽度，可以是像素或者百分比
   */
  private Integer showWidth;
  
  public Integer getSourceType() {
    return sourceType;
  }
  public void setSourceType(Integer sourceType) {
    this.sourceType = sourceType;
  }
  public Boolean getFormEngine() {
    return formEngine;
  }
  public void setFormEngine(Boolean formEngine) {
    this.formEngine = formEngine;
  }
  public String getFormInstanceId() {
    return formInstanceId;
  }
  public void setFormInstanceId(String formInstanceId) {
    this.formInstanceId = formInstanceId;
  }
  public Boolean getListEngine() {
    return listEngine;
  }
  public void setListEngine(Boolean listEngine) {
    this.listEngine = listEngine;
  }
  public String getListEngineCode() {
    return listEngineCode;
  }
  public void setListEngineCode(String listEngineCode) {
    this.listEngineCode = listEngineCode;
  }
  public String getListEngineVersion() {
    return listEngineVersion;
  }
  public void setListEngineVersion(String listEngineVersion) {
    this.listEngineVersion = listEngineVersion;
  }
  public String getShowTitle() {
    return showTitle;
  }
  public void setShowTitle(String showTitle) {
    this.showTitle = showTitle;
  }
  public Integer getShowHight() {
    return showHight;
  }
  public void setShowHight(Integer showHight) {
    this.showHight = showHight;
  }
  public Integer getShowWidth() {
    return showWidth;
  }
  public void setShowWidth(Integer showWidth) {
    this.showWidth = showWidth;
  }
  
}
