package com.bizunited.platform.mars.policy.process.cache.mutex;

import org.apache.commons.lang3.Validate;

import com.bizunited.platform.mars.entity.RuleLockNodeEntity;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;

import io.swagger.annotations.ApiModelProperty;

/**
 * 锁组件运行时节点
 * TODO 还要定义属性
 * @author yinwenjie
 */
public class RuntimeMutexNode extends RuntimeNode implements Mappable<RuleNodeEntity, RuntimeMutexNode> {
  
  /**
   * 锁表达式,例如"${object.value}_a_b"，其中object代表上下文中的某个对象
   */
  @ApiModelProperty(name = "expression", value = "锁表达式")
  private String expression; 
  
  @Override
  public RuntimeMutexNode mappingTransform(RuleNodeEntity ruleNode) {
    /*
     * 完成基本运行时时节点信息处理后，还要进行锁节点运行时特有信息的赋值
     * */
    RuntimeMutexNode runtimeMutexNode = super.doMappingTransform(RuntimeMutexNode.class, ruleNode);
    RuleLockNodeEntity ruleLockNode = ruleNode.getRuleLockExt();
    Validate.notNull(ruleLockNode , "TODO 异常信息");
    runtimeMutexNode.setExpression(ruleLockNode.getExpression());
    return runtimeMutexNode;
  }

  public String getExpression() {
    return expression;
  }

  public void setExpression(String expression) {
    this.expression = expression;
  }

}
