package com.bizunited.platform.mars.policy.process.cache.waiter;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;

/**
 * 计时等待节点的运行时定义
 * TOOD 看一下数据是否还需要完善
 * @author yinwenjie
 *
 */
public class RuntimeTimerNode extends RuntimeDelayNode implements Mappable<RuleNodeEntity, RuntimeTimerNode> {

  /**
   * 时间阻塞节点是需要真正进行延迟的节点
   */
  @Override
  public boolean realDelayed() {
    return true;
  }

  @Override
  public RuntimeTimerNode mappingTransform(RuleNodeEntity ruleNode) {
    return super.doMappingTransform(RuntimeTimerNode.class, ruleNode);
  }
}