package com.bizunited.platform.mars.policy.process.configuration;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 这是一个专门的spring配置器，里面配置了两个线程池</br>
 * mars_timer_thread_pool：该线程池专门用于处理starterable性质的节点的启动信号工作；</br>
 * mars_extcutor_thread_pool：该线程池专门用于正式执行规则链路定义
 * @author yinwenjie
 */
@Configuration
public class MarsExecutorConfig {
  
  /**
   * TODO 注释未写
   * @return
   */
  @Bean("mars_timer_thread_pool")
  public ThreadPoolExecutor getMarsTimerThreadPool() {
    ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 10, 0, TimeUnit.SECONDS, new LinkedBlockingDeque<>());
    return threadPoolExecutor;
  }
  
  /**
   * TODO 注释未写
   * @return
   */
  @Bean("mars_extcutor_thread_pool")
  public ThreadPoolExecutor getMarsExtcutorThreadPool() {
    ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(10, 100, 30, TimeUnit.SECONDS, new LinkedBlockingDeque<>(500));
    return threadPoolExecutor;
  }
}
