package com.bizunited.platform.mars.policy.process.executor;

import java.util.HashMap;
import java.util.Map;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.end.RuntimeEndNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeAggregateDataViewNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeDataViewNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeDynamicScriptNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeScriptNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeServicableNode;
import com.bizunited.platform.mars.policy.process.cache.mutex.RuntimeMutexNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeConcurrentAggregationNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeConditionNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeParallelBranchNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeStartNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeTimerNode;
import com.bizunited.platform.mars.policy.process.rule.Ruleable;
import com.bizunited.platform.mars.policy.process.rule.conditions.ConditionRuleable;
import com.bizunited.platform.mars.policy.process.rule.end.SimpleEndRuleable;
import com.bizunited.platform.mars.policy.process.rule.logic.DataviewProcessRuleable;
import com.bizunited.platform.mars.policy.process.rule.logic.DynamicGroovyScriptProcessRuleable;
import com.bizunited.platform.mars.policy.process.rule.logic.GroovyScriptProcessRuleable;
import com.bizunited.platform.mars.policy.process.rule.logic.ServicableProcessRuleable;
import com.bizunited.platform.mars.policy.process.rule.mutex.RedisMutexLockRuleable;
import com.bizunited.platform.mars.policy.process.rule.starter.SimpleStarterRuleable;
import com.bizunited.platform.mars.policy.process.rule.waiter.ConcurrentAggregationRuleable;
import com.bizunited.platform.mars.policy.process.rule.waiter.ParallelBranchRuleable;
import com.bizunited.platform.mars.policy.process.rule.waiter.TimerRuleable;

/**
 * 当前已知的具体执行器和节点的对应关系
 * @author yinwenjie
 *
 */
public final class RuntimeRuleMapping {
  /**
   * 映射关系
   */
  @SuppressWarnings("rawtypes")
  public static final Map<Class<? extends RuntimeNode> , Class<? extends Ruleable>>  MAPPING = new HashMap<>();
  static {
    MAPPING.put(RuntimeEndNode.class, SimpleEndRuleable.class);
    // 可进行规则链路运行的开始类节点，和对应的运行器
    MAPPING.put(RuntimeStartNode.class, SimpleStarterRuleable.class);
    MAPPING.put(RuntimeTimerNode.class, TimerRuleable.class);
    MAPPING.put(RuntimeConditionNode.class, ConditionRuleable.class);
    MAPPING.put(RuntimeConcurrentAggregationNode.class, ConcurrentAggregationRuleable.class);
    MAPPING.put(RuntimeParallelBranchNode.class, ParallelBranchRuleable.class);
    // 锁相关节点，和对应的运行器
    MAPPING.put(RuntimeMutexNode.class, RedisMutexLockRuleable.class);
    // 进行逻辑处理节点
    MAPPING.put(RuntimeAggregateDataViewNode.class, ConcurrentAggregationRuleable.class);
    MAPPING.put(RuntimeDataViewNode.class, DataviewProcessRuleable.class);
    MAPPING.put(RuntimeDynamicScriptNode.class, DynamicGroovyScriptProcessRuleable.class);
    MAPPING.put(RuntimeScriptNode.class, GroovyScriptProcessRuleable.class);
    MAPPING.put(RuntimeServicableNode.class, ServicableProcessRuleable.class);
  }
}
