package com.bizunited.platform.mars.policy.process.rule.conditions;

import java.util.Set;

import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeConditionNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 简单的条件规则的顶层定义
 * @author yinwenjie
 */
@Component("simpleConditionRuleable")
public class SimpleConditionRuleable<T extends RuntimeConditionNode> implements ConditionRuleable<T> {
  
  @Override
  public int getType() {
    return RuntimeNodeType.CONDITION.getValue();
  }

  @Override
  public void doProcess(RuntimeConditionNode currentNode ,RuleRuntimeContext context , RuntimeProcessorLinked runtimeProcessorLinked , ProcessorChain processChain) {
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }
  
  @Override
  public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeConditionNode currentNode, RuleRuntimeContext context) {
    /*
     * 在接收到继续的通知，正式开始继续执行前，SimpleConditionRuleable节点会依次检查所有的条件分支，
     * 找到最匹配的分支运行条件后，继续执行，
     * 
     * TODO 如果没有找到任何匹配的条件分支，则会抛出错误，要求结束规则实例的执行过程
     * 
     * 一旦进入dowait方法，表示当前规则链路可以进行终止，但是整个规则实例并没有执行完成
     * 当前规则链路对应的processChain将终止多元递归执行，并更改当前规则链路在当前规则实例上下文中的状态，
     * 在doWait方法执行后，processChain还会将当前RuntimeNode节点推送到等待计时器中
     * */
    return null;
  }
}