package com.bizunited.platform.mars.policy.process.rule.end;

import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.end.RuntimeEndNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 一个默认的结束规则处理器，里面实际上什么都没有
 * @author yinwenjie
 */
@Component("SimpleEndRuleable")
public class SimpleEndRuleable<T extends RuntimeEndNode> implements EndRuleable<T> {
  
  @Override
  public void doProcess(RuntimeEndNode currentNode ,RuleRuntimeContext context ,RuntimeProcessorLinked runtimeProcessorLinked  , ProcessorChain processChain) {
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }

  @Override
  public String description() {
    return "默认的结束节点处理器";
  }
}