package com.bizunited.platform.mars.policy.process.rule.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeLogicAble;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * TODO 注释未写
 * @author yinwenjie
 */
public abstract class AbstractLogicRuleable <T extends RuntimeLogicAble> {
  /**
   * TODO 注释未写
   * @param node
   */
  public void process(T currentNode , RuntimeProcessorLinked runtimeProcessorLinked) {
    // 取得上下文信息
    String instanceId = currentNode.getInstanceId();
    RuleRuntimeContext context = RuleRuntimeContext.getRuleRuntimeContext(instanceId);
    Validate.notNull(context , "当前运行的节点定义未发现运行上下文信息，请检查!!");
    // 验证当前节点的正确性
    String code = currentNode.getCode();
    Validate.notBlank(code , "当前运行的节点定义未发现业务编号信息，请检查!!");
    Map<String , Object> contentMap = context.getParams();
    
    // 取得已设定的入参和出参信息（基于固定值或者上下文值进行取数）
    // 优先考虑前者
    Set<RuntimeNodeParams> inputParams = currentNode.getInputs();
    Map<String , Object> inputParamValues = new HashMap<>();
    if(!CollectionUtils.isEmpty(inputParams)) {
      inputParams.forEach(item -> {
        String contextParamName = item.getContextParamName();
        String fixValue = item.getFixedValue();
        String paramType = item.getParamType();
        Object paramValue = null;
        if(!StringUtils.isBlank(fixValue)) {
          try {
            paramValue = this.parseValue(fixValue, paramType);
          } catch(RuntimeException e) {
            throw new IllegalArgumentException(String.format("固定值转换出现问题[%s]，请检查规则定义中节点[%s]的固定入参设置。", e.getMessage() , code));
          }
        } else {
          paramValue = contentMap.get(contextParamName);
        }
        if(paramValue == null && item.getNullable()) {
          throw new IllegalArgumentException(String.format("运行节点[%s]时，未发现必须传入的入参[%s]，请检查!!", code , contextParamName));
        }
        String templateParamName = item.getTemplateParamName();
        inputParamValues.put(templateParamName, paramValue);
      });
    } 
    this.execute((T)currentNode, inputParamValues, context);
  } 
  
  /**
   * TODO 注释未写
   * @param currentNode
   * @param inputParamValues
   * @param context
   */
  protected abstract void execute(T currentNode , Map<String , Object> inputParamValues , RuleRuntimeContext context);
  
  private Object parseValue(String fixValue , String type) {
    if(StringUtils.equals(type, "long")) {
      return Long.valueOf(fixValue);
    } else if(StringUtils.equals(type, "int")) {
      return Integer.valueOf(fixValue);
    } else if(StringUtils.equals(type, "float")) {
      return Float.valueOf(fixValue);
    } else if(StringUtils.equals(type, "boolean")) {
      return Boolean.valueOf(fixValue);
    } else if(StringUtils.equals(type, "double")) {
      return Double.valueOf(fixValue);
    } else if(StringUtils.equals(type, "short")) {
      return Short.valueOf(fixValue);
    } else if(StringUtils.equals(type, "short")) {
      return Byte.valueOf(fixValue);
    } 
    // 其它全部统一为字符串
    return fixValue;
  }
}
