package com.bizunited.platform.mars.policy.process.rule.logic;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeDataViewNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;

/**
 * 基于数据视图（集合）节点的逻辑运行器
 * @author yinwenjie
 */
@Component("dataviewProcessRuleable")
public class DataviewProcessRuleable<T extends RuntimeDataViewNode> extends AbstractLogicRuleable<RuntimeDataViewNode> implements LogicRuleable<T> {

  @Autowired
  private RuntimeNodeService runtimeNodeService;
  
  @Override
  public void doProcess(RuntimeDataViewNode currentNode, RuleRuntimeContext context ,RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    super.process(currentNode, runtimeProcessorLinked);
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }

  @Override
  protected void execute(RuntimeDataViewNode currentNode, Map<String, Object> inputParamValues, RuleRuntimeContext context) {
    // TODO 逻辑代码没有写
  }
}
