package com.bizunited.platform.mars.policy.process.rule.logic;

import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeServicableNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 基于服务源的
 * @author yinwenjie
 */
@Component("servicableProcessRuleable")
public class ServicableProcessRuleable<T extends RuntimeServicableNode> extends AbstractLogicRuleable<RuntimeServicableNode> implements LogicRuleable<T> {
  @Autowired
  private ServicableMethodService servicableMethodService;
  
  @Override
  public void doProcess(RuntimeServicableNode currentNode, RuleRuntimeContext context,RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    super.process(currentNode, runtimeProcessorLinked);
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }

  @Override
  protected void execute(RuntimeServicableNode currentNode, Map<String , Object> inputParamValues, RuleRuntimeContext context) {
    String code = currentNode.getCode();
    // 取得并判定处理源信息
    String servicableMethod = currentNode.getServicableMethod();
    Validate.notBlank(servicableMethod , "运行节点[%s]时，未发现指定的服务源信息，请检查!!" , code);
    // 开始准备调用服务源
    InvokeParams invokeParams = new InvokeParams(inputParamValues);
    Object result = null;
    try {
      result = this.servicableMethodService.invoke(servicableMethod, invokeParams);
    } catch(InvokeProxyException e) {
      throw new IllegalArgumentException(e.getMessage() , e);
    }
    
    // 服务源调用成功后，视配置信息，决定将返回值写入规则上下文
    Map<String , Object> contentMap = context.getParams();
    Set<RuntimeNodeParams> outputParams = currentNode.getOutputs();
    Validate.isTrue(outputParams == null || outputParams.size() == 0  || (outputParams != null && outputParams.size() == 1) , "运行节点[%s]时，发现其设定的出参不符合要求(要么不设定返回值，要么只设置一个返回值参数)!!" , code);
    if(outputParams != null) {
      RuntimeNodeParams outputParam = outputParams.iterator().next();
      String contextParamName = outputParam.getContextParamName();
      contentMap.put(contextParamName, result);
    }
  } 
} 
