package com.bizunited.platform.mars.policy.process.rule.starter;

import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeStartNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.google.common.collect.Sets;

/**
 * 开始规则的简单实现，其中创建规则链路的时候，只有一条连接线
 * @author yinwenjie
 */
@Component("simpleStarterRuleable")
public class SimpleStarterRuleable<T extends RuntimeStartNode> implements StarterRuleable<RuntimeStartNode> {
  @Override
  public void doProcess(RuntimeStartNode currentNode ,RuleRuntimeContext context ,RuntimeProcessorLinked runtimeProcessorLinked , ProcessorChain processChain) {
    /*
     * 开始位置，会按照当前开始节点的定义，检查入参情况是否满足
     * */
    Set<RuntimeNodeParams> runtimeNodeParams = currentNode.getInputs();
    Map<String, Object> contextParamMapping = context.getParams();
    
    if(runtimeNodeParams != null) {
      for (RuntimeNodeParams nodeParam : runtimeNodeParams) {
        boolean nullable = nodeParam.getNullable();
        String contextParamName = nodeParam.getContextParamName();
        if(nullable && contextParamMapping.get(contextParamName) == null) {
          throw new IllegalArgumentException(String.format("本规则实例要求[%s]作为入参，但是在运行开始时的检测中，并为发现该参数传入，请检查调用时的传参!!", contextParamName));
        }
      }
    }
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }

  @Override
  public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeStartNode currentNode, RuleRuntimeContext context) {
    /*
     * 作为普通的，代表整个规则定义的开始节点，可以无条件启动运行
     * 按照当前规则定义，找到第一个处理点和处理连线即可
     * */
    Set<RuntimeNodeNexts> runtimeNodeNexts = currentNode.getNexts();
    Validate.isTrue(!CollectionUtils.isEmpty(runtimeNodeNexts) , "未发现当前节点运行时[%s]存在任何后续连线，请检查!!" , currentNode.getCode());
    Validate.isTrue(runtimeNodeNexts.size() == 1 , "当前开始节点的运行时定义，只能由一条连线，请检查!!");
    RuntimeNodeNexts currentRuntimeNodeNext = runtimeNodeNexts.iterator().next();
    
    // 为当前上下文设定规则链路，以便进行执行
    RuntimeProcessorLinked runtimeProcessorLinked = new RuntimeProcessorLinked(currentNode, currentRuntimeNodeNext);
    return Sets.newHashSet(runtimeProcessorLinked);
  }
}