package com.bizunited.platform.mars.policy.process.rule.waiter;

import java.util.Set;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeConcurrentAggregationNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.starter.StarterRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 并行汇聚节点，只有当该节点所有前置分支链路全部成功执行，该汇聚节点才会继续向后执行
 * @author yinwenjie
 *
 */
public class ConcurrentAggregationRuleable<T extends RuntimeConcurrentAggregationNode> implements StarterRuleable<T> {
  public int getType() {
    return RuntimeNodeType.CONCURRENCY.getValue();
  }
  
  @Override
  public void doProcess(RuntimeConcurrentAggregationNode currentNode, RuleRuntimeContext context,RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    /*
     * 该节点没有任何业务动作
     * */
  }
  
  @Override
  public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeConcurrentAggregationNode currentNode, RuleRuntimeContext context) {
    /*
     * 在接收到继续的通知，正式开始继续执行前，ConcurrentAggregationRuleable节点会做以下判定：
     * 1、规则实例中，是否所有以当前节点为结束节点的规则链路都已经执行完毕
     * 2、以上判定成立的条件下，是否所有所有链路都执行成功了
     * 
     * TODO 只有以上两个条件都成立的情况下，才会创建后续规则链路，并继续执行
     * */
    return null;
  }
}
