package com.bizunited.platform.mars.policy.process.rule.waiter;

import java.util.Set;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeParallelBranchNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.starter.StarterRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 可用于A/B测试的并行分支
 * @author yinwenjie
 *
 */
public class ParallelBranchRuleable<T extends RuntimeParallelBranchNode> implements StarterRuleable<RuntimeParallelBranchNode> {
  public int getType() {
    return RuntimeNodeType.MERGE.getValue();
  }
  @Override
  public void doProcess(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context,RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }
  
  @Override
  public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context) {
    /*
     * 在接收到继续的通知，正式开始继续执行前，ParallelBranchRuleable节点会依次检查所有的条件分支，
     * 找到所有匹配条件的分支，并为这些分支的后续执行创建多个规则链路的初始状态，并向下执行
     * 
     * TODO 如果没有找到任何匹配的条件分支，则会抛出错误，要求结束规则实例的执行过程
     * */
    return null;
  }
}
